/*
 * Decompiled with CFR 0.152.
 */
package ai.waii;

import ai.waii.WaiiHttpClient;
import ai.waii.clients.accesskey.AccessKey;
import ai.waii.clients.authorization.Authorization;
import ai.waii.clients.chart.Chart;
import ai.waii.clients.chat.Chat;
import ai.waii.clients.database.Database;
import ai.waii.clients.healthcheck.HealthCheck;
import ai.waii.clients.history.History;
import ai.waii.clients.model.LLM;
import ai.waii.clients.query.Query;
import ai.waii.clients.semanticcontext.SemanticContext;
import ai.waii.clients.user.User;

public final class Waii {
    private WaiiHttpClient httpClient;
    private History history;
    private SemanticContext semanticContext;
    private Query query;
    private Database database;
    private AccessKey accessKey;
    private HealthCheck healthCheck;
    private Authorization authorization;
    private LLM llm;
    private User user;
    private Chart chart;
    private Chat chat;

    public Waii(String url, String apiKey) {
        this.initialize(url, apiKey);
    }

    public void initialize(String url, String apiKey) {
        this.httpClient = new WaiiHttpClient(url, apiKey);
        this.history = new History(this.httpClient);
        this.semanticContext = new SemanticContext(this.httpClient);
        this.query = new Query(this.httpClient);
        this.database = new Database(this.httpClient);
        this.accessKey = new AccessKey(this.httpClient);
        this.healthCheck = new HealthCheck(this.httpClient);
        this.authorization = new Authorization(this.httpClient);
        this.llm = new LLM(this.httpClient);
        this.user = new User(this.httpClient);
        this.chart = new Chart(this.httpClient);
        this.chat = new Chat(this.httpClient);
    }

    public WaiiHttpClient getHttpClient() {
        return this.httpClient;
    }

    public History getHistory() {
        return this.history;
    }

    public SemanticContext getSemanticContext() {
        return this.semanticContext;
    }

    public Query getQuery() {
        return this.query;
    }

    public Database getDatabase() {
        return this.database;
    }

    public AccessKey getAccessKey() {
        return this.accessKey;
    }

    public HealthCheck getHealthCheck() {
        return this.healthCheck;
    }

    public Authorization getAuthorization() {
        return this.authorization;
    }

    public LLM getLLM() {
        return this.llm;
    }

    public User getUser() {
        return this.user;
    }

    public Chart getChart() {
        return this.chart;
    }

    public Chat getChat() {
        return this.chat;
    }
}

