/*
 * Decompiled with CFR 0.152.
 */
package ai.waii.clients.chart;

import ai.waii.WaiiHttpClient;
import ai.waii.clients.chart.ChartGenerationRequest;
import ai.waii.clients.chart.ChartGenerationResponse;
import ai.waii.clients.chart.ChartSpec;
import ai.waii.clients.chart.MetabaseChartSpec;
import ai.waii.clients.chart.SuperSetChartSpec;
import ai.waii.clients.chart.VegaliteChartSpec;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.lang.reflect.Type;

public class Chart {
    private final WaiiHttpClient httpClient;
    private static final String GENERATE_ENDPOINT = "generate-chart";

    public Chart(WaiiHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public ChartGenerationResponse generate(ChartGenerationRequest params) throws IOException {
        Gson gson = new GsonBuilder().registerTypeAdapter(ChartSpec.class, (Object)new ChartSpecDeserializer()).create();
        String jsonParams = gson.toJson((Object)params);
        String jsonResponse = this.httpClient.commonFetchRaw(GENERATE_ENDPOINT, jsonParams);
        return (ChartGenerationResponse)gson.fromJson(jsonResponse, ChartGenerationResponse.class);
    }

    public static class ChartSpecDeserializer
    implements JsonDeserializer<ChartSpec> {
        public ChartSpec deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObject = json.getAsJsonObject();
            if (jsonObject.has("spec_type")) {
                if (jsonObject.get("spec_type").getAsString().equals("superset")) {
                    return (ChartSpec)context.deserialize(json, SuperSetChartSpec.class);
                }
                if (jsonObject.get("spec_type").getAsString().equals("metabase")) {
                    return (ChartSpec)context.deserialize(json, MetabaseChartSpec.class);
                }
                if (jsonObject.get("spec_type").getAsString().equals("vegalite")) {
                    return (ChartSpec)context.deserialize(json, VegaliteChartSpec.class);
                }
            }
            return null;
        }
    }
}

