/*
 * Decompiled with CFR 0.152.
 */
package ai.waii.clients.chat;

import ai.waii.WaiiHttpClient;
import ai.waii.clients.AsyncObjectResponse;
import ai.waii.clients.GetObjectRequest;
import ai.waii.clients.chart.Chart;
import ai.waii.clients.chart.ChartSpec;
import ai.waii.clients.chat.ChatRequest;
import ai.waii.clients.chat.ChatResponse;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;

public class Chat {
    private final WaiiHttpClient httpClient;
    private static final String CHAT_ENDPOINT = "chat-message";
    private static final String SUBMIT_CHAT_ENDPOINT = "submit-chat-message";
    private static final String GET_CHAT_ENDPOINT = "get-chat-response";

    public Chat(WaiiHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public ChatResponse chat(ChatRequest params) throws IOException {
        Gson gson = new GsonBuilder().registerTypeAdapter(ChartSpec.class, (Object)new Chart.ChartSpecDeserializer()).create();
        String jsonParams = gson.toJson((Object)params);
        String jsonResponse = this.httpClient.commonFetchRaw(CHAT_ENDPOINT, jsonParams);
        return (ChatResponse)gson.fromJson(jsonResponse, ChatResponse.class);
    }

    public AsyncObjectResponse submitChat(ChatRequest params) throws IOException {
        Gson gson = new GsonBuilder().registerTypeAdapter(ChartSpec.class, (Object)new Chart.ChartSpecDeserializer()).create();
        String jsonParams = gson.toJson((Object)params);
        return this.httpClient.commonFetch(SUBMIT_CHAT_ENDPOINT, jsonParams, AsyncObjectResponse.class);
    }

    public ChatResponse getChatResponse(GetObjectRequest params) throws IOException {
        Gson gson = new GsonBuilder().registerTypeAdapter(ChartSpec.class, (Object)new Chart.ChartSpecDeserializer()).create();
        String jsonParams = gson.toJson((Object)params);
        String jsonResponse = this.httpClient.commonFetchRaw(GET_CHAT_ENDPOINT, jsonParams);
        return (ChatResponse)gson.fromJson(jsonResponse, ChatResponse.class);
    }
}

