/*
 * Decompiled with CFR 0.152.
 */
package ai.waii.clients.database;

import ai.waii.WaiiHttpClient;
import ai.waii.clients.database.GetCatalogRequest;
import ai.waii.clients.database.GetCatalogResponse;
import ai.waii.clients.database.GetDBConnectionRequest;
import ai.waii.clients.database.GetDBConnectionResponse;
import ai.waii.clients.database.ModifyDBConnectionRequest;
import ai.waii.clients.database.ModifyDBConnectionResponse;
import ai.waii.clients.database.UpdateColumnDescriptionRequest;
import ai.waii.clients.database.UpdateSchemaDescriptionRequest;
import ai.waii.clients.database.UpdateTableDescriptionRequest;
import com.google.gson.Gson;
import java.io.IOException;

public class Database {
    private final WaiiHttpClient httpClient;
    private static final String MODIFY_DB_ENDPOINT = "update-db-connect-info";
    private static final String GET_CATALOG_ENDPOINT = "get-table-definitions";
    private static final String UPDATE_TABLE_DESCRIPTION_ENDPOINT = "update-table-description";
    private static final String UPDATE_SCHEMA_DESCRIPTION_ENDPOINT = "update-schema-description";
    private static final String UPDATE_COLUMN_DESCRIPTION_ENDPOINT = "update-column-description";
    private static final String EXTRACT_DATABASE_DOCUMENTATION_ENDPOINT = "extract-database-documentation";

    public Database(WaiiHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public ModifyDBConnectionResponse modifyConnections(ModifyDBConnectionRequest params) throws IOException {
        String jsonParams = new Gson().toJson((Object)params);
        return this.httpClient.commonFetch(MODIFY_DB_ENDPOINT, jsonParams, ModifyDBConnectionResponse.class);
    }

    public GetDBConnectionResponse getConnections(GetDBConnectionRequest params) throws IOException {
        String jsonParams = new Gson().toJson((Object)params);
        return this.httpClient.commonFetch(MODIFY_DB_ENDPOINT, jsonParams, GetDBConnectionResponse.class);
    }

    public ModifyDBConnectionResponse activateConnection(String key) throws IOException {
        this.httpClient.setScope(key);
        ModifyDBConnectionRequest request = new ModifyDBConnectionRequest();
        request.setDefaultDbConnectionKey(key);
        String jsonParams = new Gson().toJson((Object)request);
        return this.httpClient.commonFetch(MODIFY_DB_ENDPOINT, jsonParams, ModifyDBConnectionResponse.class);
    }

    public GetCatalogResponse getCatalogs(GetCatalogRequest params) throws IOException {
        String jsonParams = new Gson().toJson((Object)params);
        return this.httpClient.commonFetch(GET_CATALOG_ENDPOINT, jsonParams, GetCatalogResponse.class);
    }

    public String getDefaultConnection() {
        return this.httpClient.getScope();
    }

    public ModifyDBConnectionResponse updateTableDescription(UpdateTableDescriptionRequest params) throws IOException {
        String jsonParams = new Gson().toJson((Object)params);
        return this.httpClient.commonFetch(UPDATE_TABLE_DESCRIPTION_ENDPOINT, jsonParams, ModifyDBConnectionResponse.class);
    }

    public ModifyDBConnectionResponse updateSchemaDescription(UpdateSchemaDescriptionRequest params) throws IOException {
        String jsonParams = new Gson().toJson((Object)params);
        return this.httpClient.commonFetch(UPDATE_SCHEMA_DESCRIPTION_ENDPOINT, jsonParams, ModifyDBConnectionResponse.class);
    }

    public ModifyDBConnectionResponse updateColumnDescription(UpdateColumnDescriptionRequest params) throws IOException {
        String jsonParams = new Gson().toJson((Object)params);
        return this.httpClient.commonFetch(UPDATE_COLUMN_DESCRIPTION_ENDPOINT, jsonParams, ModifyDBConnectionResponse.class);
    }
}

