/*
 * Decompiled with CFR 0.152.
 */
package ai.waii.clients.history;

import ai.waii.WaiiHttpClient;
import ai.waii.clients.history.GeneratedChartHistoryEntry;
import ai.waii.clients.history.GeneratedChatHistoryEntry;
import ai.waii.clients.history.GeneratedQueryHistoryEntry;
import ai.waii.clients.history.GetGeneratedQueryHistoryRequest;
import ai.waii.clients.history.GetGeneratedQueryHistoryResponse;
import ai.waii.clients.history.HistoryEntry;
import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.lang.reflect.Type;

public class History {
    private final WaiiHttpClient httpClient;
    private static final String GET_ENDPOINT = "get-generated-query-history";

    public History(WaiiHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public GetGeneratedQueryHistoryResponse list(GetGeneratedQueryHistoryRequest params) throws IOException {
        Gson gson = new Gson().newBuilder().registerTypeAdapter(HistoryEntry.class, (Object)new HistoryEntryDeserializer()).create();
        String jsonParams = gson.toJson((Object)params);
        return (GetGeneratedQueryHistoryResponse)gson.fromJson(this.httpClient.commonFetchRaw(GET_ENDPOINT, jsonParams), GetGeneratedQueryHistoryResponse.class);
    }

    public static class HistoryEntryDeserializer
    implements JsonDeserializer<HistoryEntry> {
        public HistoryEntry deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObject = json.getAsJsonObject();
            JsonElement typeElement = jsonObject.get("history_type");
            if (typeElement != null) {
                String historyType;
                switch (historyType = typeElement.getAsString()) {
                    case "query": {
                        return (HistoryEntry)context.deserialize(json, GeneratedQueryHistoryEntry.class);
                    }
                    case "chart": {
                        return (HistoryEntry)context.deserialize(json, GeneratedChartHistoryEntry.class);
                    }
                    case "chat": {
                        return (HistoryEntry)context.deserialize(json, GeneratedChatHistoryEntry.class);
                    }
                }
                throw new JsonParseException("Unknown element type: " + historyType);
            }
            throw new JsonParseException("history_type field is missing");
        }
    }
}

