/*
 * Decompiled with CFR 0.152.
 */
package ai.waii.clients.semanticcontext;

import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.UUID;

public class SemanticStatement {
    private String id;
    private String scope;
    private String statement;
    private String[] labels;
    @SerializedName(value="always_include")
    private Boolean alwaysInclude;
    @SerializedName(value="lookup_summaries")
    private String[] lookupSummaries;
    @SerializedName(value="summarization_prompt")
    private String summarizationPrompt;
    private Boolean critical;
    private Boolean enabled;
    private List<SemanticStatementWarning> warnings;
    @SerializedName(value="user_id")
    private String userId;
    @SerializedName(value="tenant_id")
    private String tenantId;
    @SerializedName(value="org_id")
    private String orgId;

    public SemanticStatement() {
        this.scope = "*";
        this.labels = new String[0];
        this.alwaysInclude = true;
        this.lookupSummaries = new String[0];
        this.summarizationPrompt = "";
        this.id = UUID.randomUUID().toString();
        this.critical = false;
        this.enabled = true;
        this.warnings = null;
        this.userId = "*";
        this.tenantId = "*";
        this.orgId = "*";
    }

    public SemanticStatement(String scope, String statement, String[] labels, Boolean alwaysInclude, String[] lookupSummaries, String summarizationPrompt, String id, Boolean critical) {
        this.scope = scope;
        this.statement = statement;
        this.labels = labels;
        this.alwaysInclude = alwaysInclude;
        this.lookupSummaries = lookupSummaries;
        this.summarizationPrompt = summarizationPrompt;
        this.critical = critical;
        this.id = id != null && !id.isEmpty() ? id : UUID.randomUUID().toString();
        this.enabled = true;
        this.warnings = null;
        this.userId = "*";
        this.tenantId = "*";
        this.orgId = "*";
    }

    public String getId() {
        return this.id;
    }

    public SemanticStatement setId(String id) {
        this.id = id;
        return this;
    }

    public String getScope() {
        return this.scope;
    }

    public SemanticStatement setScope(String scope) {
        this.scope = scope;
        return this;
    }

    public String getStatement() {
        return this.statement;
    }

    public SemanticStatement setStatement(String statement) {
        this.statement = statement;
        return this;
    }

    public String[] getLabels() {
        return this.labels;
    }

    public SemanticStatement setLabels(String[] labels) {
        this.labels = labels;
        return this;
    }

    public Boolean getAlwaysInclude() {
        return this.alwaysInclude;
    }

    public SemanticStatement setAlwaysInclude(Boolean alwaysInclude) {
        this.alwaysInclude = alwaysInclude;
        return this;
    }

    public Boolean getCritical() {
        return this.critical;
    }

    public SemanticStatement setCritical(Boolean critical) {
        this.critical = critical;
        return this;
    }

    public String[] getLookupSummaries() {
        return this.lookupSummaries;
    }

    public SemanticStatement setLookupSummaries(String[] lookupSummaries) {
        this.lookupSummaries = lookupSummaries;
        return this;
    }

    public String getSummarizationPrompt() {
        return this.summarizationPrompt;
    }

    public SemanticStatement setSummarizationPrompt(String summarizationPrompt) {
        this.summarizationPrompt = summarizationPrompt;
        return this;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public SemanticStatement setEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public List<SemanticStatementWarning> getWarnings() {
        return this.warnings;
    }

    public SemanticStatement setWarnings(List<SemanticStatementWarning> warnings) {
        this.warnings = warnings;
        return this;
    }

    public String getUserId() {
        return this.userId;
    }

    public SemanticStatement setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public SemanticStatement setTenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public String getOrgId() {
        return this.orgId;
    }

    public SemanticStatement setOrgId(String orgId) {
        this.orgId = orgId;
        return this;
    }

    public static class SemanticStatementWarning {
        private String message;
        private String type;

        public SemanticStatementWarning() {
        }

        public SemanticStatementWarning(String message, String type) {
            this.message = message;
            this.type = type;
        }

        public String getMessage() {
            return this.message;
        }

        public SemanticStatementWarning setMessage(String message) {
            this.message = message;
            return this;
        }

        public String getType() {
            return this.type;
        }

        public SemanticStatementWarning setType(String type) {
            this.type = type;
            return this;
        }
    }
}

