package ai.waii.clients.chart;

import java.io.IOException;
import java.lang.reflect.Type;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;

import ai.waii.WaiiHttpClient;

public class Chart {

    private final WaiiHttpClient httpClient;
    private static final String GENERATE_ENDPOINT = "generate-chart";

    public Chart(WaiiHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public ChartGenerationResponse generate(ChartGenerationRequest params) throws IOException {
        Gson gson = new GsonBuilder()
                .registerTypeAdapter(ChartSpec.class, new ChartSpecDeserializer())
                .create();

        String jsonParams = gson.toJson(params);
        String jsonResponse = this.httpClient.commonFetchRaw(GENERATE_ENDPOINT, jsonParams);
        return gson.fromJson(jsonResponse, ChartGenerationResponse.class);
    }

    public static class ChartSpecDeserializer implements JsonDeserializer<ChartSpec> {

        @Override
        public ChartSpec deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObject = json.getAsJsonObject();
            //System.out.println(jsonObject);
            if (jsonObject.has("spec_type")) {
                if (jsonObject.get("spec_type").getAsString().equals("superset")) {
                    return context.deserialize(json, SuperSetChartSpec.class);
                }

                if (jsonObject.get("spec_type").getAsString().equals("metabase")) {
                    return context.deserialize(json, MetabaseChartSpec.class);
                }

                if (jsonObject.get("spec_type").getAsString().equals("vegalite")) {
                    return context.deserialize(json, VegaliteChartSpec.class);
                }
            }

            return null;
        }
    }
}
