package ai.waii.clients.chat;

import com.google.gson.annotations.SerializedName;

import ai.waii.clients.chart.ChartGenerationResponse;
import ai.waii.clients.database.Catalog;
import ai.waii.clients.query.GeneratedQuery;
import ai.waii.clients.query.GetQueryResultResponse;
import ai.waii.clients.semanticcontext.GetSemanticContextResponse;

public class ChatResponseData {

    private GetQueryResultResponse data;
    private GeneratedQuery query;
    @SerializedName("chart")
    private ChartGenerationResponse chart;
    @SerializedName("python_plot")
    private Object pythonPlot;
    @SerializedName("semantic_context")
    private GetSemanticContextResponse semanticContext;
    private Catalog tables;
    @SerializedName("debug_info")
    private ChatError debugInfo;

    public GetQueryResultResponse getData() {
        return data;
    }

    public void setData(GetQueryResultResponse data) {
        this.data = data;
    }

    public GeneratedQuery getQuery() {
        return query;
    }

    public void setQuery(GeneratedQuery query) {
        this.query = query;
    }

    public ChartGenerationResponse getChart() {
        return chart;
    }

    public void setChart(ChartGenerationResponse chart) {
        this.chart = chart;
    }

    public Object getPythonPlot() {
        return pythonPlot;
    }

    public void setPythonPlot(Object pythonPlot) {
        this.pythonPlot = pythonPlot;
    }

    public GetSemanticContextResponse getSemanticContext() {
        return semanticContext;
    }

    public void setSemanticContext(GetSemanticContextResponse semanticContext) {
        this.semanticContext = semanticContext;
    }

    public Catalog getTables() {
        return tables;
    }

    public void setTables(Catalog tables) {
        this.tables = tables;
    }

    public ChatError getDebugInfo() {
        return debugInfo;
    }

    public void setDebugInfo(ChatError debugInfo) {
        this.debugInfo = debugInfo;
    }

    public static class ChatError {
        @SerializedName("query_gen_error")
        private ErrorInfo queryGenError;
        @SerializedName("query_run_error")
        private ErrorInfo queryRunError;
        @SerializedName("chart_gen_error")
        private ErrorInfo chartGenError;

        public ErrorInfo getChartGenError() {
            return chartGenError;
        }

        public void setChartGenError(ErrorInfo chartGenError) {
            this.chartGenError = chartGenError;
        }

        public ErrorInfo getQueryRunError() {
            return queryRunError;
        }

        public void setQueryRunError(ErrorInfo queryRunError) {
            this.queryRunError = queryRunError;
        }

        public ErrorInfo getQueryGenError() {
            return queryGenError;
        }

        public void setQueryGenError(ErrorInfo queryGenError) {
            this.queryGenError = queryGenError;
        }
    }

    public static class ErrorInfo {
        @SerializedName("error_detail")
        private String errorDetail;
        @SerializedName("error_code")
        private Integer errorCode;

        public String getErrorDetail() {
            return errorDetail;
        }

        public void setErrorDetail(String errorDetail) {
            this.errorDetail = errorDetail;
        }

        public Integer getErrorCode() {
            return errorCode;
        }

        public void setErrorCode(Integer errorCode) {
            this.errorCode = errorCode;
        }
    }
}
