package ai.waii.clients.history;

import com.google.gson.annotations.SerializedName;

public class GetGeneratedQueryHistoryRequest {

    @SerializedName("included_type")
    private GeneratedHistoryEntryType[] includedTypes = {GeneratedHistoryEntryType.QUERY};
    private Integer limit;
    private Integer offset;
    @SerializedName("timestamp_sort_order")
    SortOrder timestampSortOrder;
    @SerializedName("uuid_filter")
    private String uuidFilter;

    public Integer getLimit() {
        return limit;
    }

    public GetGeneratedQueryHistoryRequest setLimit(Integer limit) {
        this.limit = limit;
        return this;
    }

    public Integer getOffset() {
        return offset;
    }

    public GetGeneratedQueryHistoryRequest setOffset(Integer offset) {
        this.offset = offset;
        return this;
    }

    public GeneratedHistoryEntryType[] getIncludedTypes() {
        return includedTypes;
    }

    public void setIncludedTypes(GeneratedHistoryEntryType[] includedTypes) {
        this.includedTypes = includedTypes;
    }

    public SortOrder getTimestampSortOrder() {
        return timestampSortOrder;
    }

    public GetGeneratedQueryHistoryRequest setTimestampSortOrder(SortOrder timestampSortOrder) {
        this.timestampSortOrder = timestampSortOrder;
        return this;
    }

    public String getUuidFilter() {
        return uuidFilter;
    }

    public GetGeneratedQueryHistoryRequest setUuidFilter(String uuidFilter) {
        this.uuidFilter = uuidFilter;
        return this;
    }
}
