package ai.waii.clients.model;

import java.io.IOException;

import com.google.gson.Gson;

import ai.waii.WaiiHttpClient;

public class LLM {

    private final WaiiHttpClient httpClient;
    private static final String GET_ENDPOINT = "get-models";
    private static final String GET_EMBEDDING_ENDPOINT = "get-embedding-models";

    public LLM(WaiiHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public GetModelsResponse getModels(GetModelsRequest params) throws IOException {
        String jsonParams = new Gson().toJson(params);
        return this.httpClient.commonFetch(GET_ENDPOINT, jsonParams, GetModelsResponse.class);
    }

    public GetEmbeddingModelsResponse getEmbeddingModels(GetModelsRequest params) throws IOException {
        String jsonParams = new Gson().toJson(params);
        return this.httpClient.commonFetch(GET_EMBEDDING_ENDPOINT, jsonParams, GetEmbeddingModelsResponse.class);
    }
}

