package ai.waii.clients.query;

import java.util.List;

import com.google.gson.annotations.SerializedName;

import ai.waii.clients.database.SearchContext;

public class AutoCompleteRequest {

    private String text;
    @SerializedName("cursor_offset") private Integer cursorOffset;
    private String dialect;
    @SerializedName("search_context") private List<SearchContext> searchContext;
    @SerializedName("max_output_tokens") private Integer maxOutputTokens;

    public AutoCompleteRequest(String text, Integer cursorOffset, String dialect, List<SearchContext> searchContext, Integer maxOutputTokens) {
        this.text = text;
        this.cursorOffset = cursorOffset;
        this.dialect = dialect;
        this.searchContext = searchContext;
        this.maxOutputTokens = maxOutputTokens;
    }

    public AutoCompleteRequest() {
    }

    public String getText() {
        return text;
    }

    public AutoCompleteRequest setText(String text) {
        this.text = text;
        return this;
    }

    public Integer getCursorOffset() {
        return cursorOffset;
    }

    public AutoCompleteRequest setCursorOffset(Integer cursorOffset) {
        this.cursorOffset = cursorOffset;
        return this;
    }

    public String getDialect() {
        return dialect;
    }

    public AutoCompleteRequest setDialect(String dialect) {
        this.dialect = dialect;
        return this;
    }

    public List<SearchContext> getSearchContext() {
        return searchContext;
    }

    public void setSearchContext(List<SearchContext> searchContext) {
        this.searchContext = searchContext;
    }

    public Integer getMaxOutputTokens() {
        return maxOutputTokens;
    }

    public void setMaxOutputTokens(Integer maxOutputTokens) {
        this.maxOutputTokens = maxOutputTokens;
    }
}
