package ai.waii.clients.query;

import java.util.List;

import com.google.gson.annotations.SerializedName;

public class DebugQueryResponse {

    private List<DebugQueryPiece> pieces;

    public DebugQueryResponse(List<DebugQueryPiece> pieces) {
        this.pieces = pieces;
    }

    public List<DebugQueryPiece> getPieces() {
        return pieces;
    }

    public void setPieces(List<DebugQueryPiece> pieces) {
        this.pieces = pieces;
    }

    public static class DebugQueryPiece {

        private String label;
        private String query;
        @SerializedName("row_count") private Integer rowCount;
        @SerializedName("error_msg") private String errorMsg;

        public DebugQueryPiece(String label, String query, Integer rowCount, String errorMsg) {
            this.label = label;
            this.query = query;
            this.rowCount = rowCount;
            this.errorMsg = errorMsg;
        }

        // Getters and Setters
        public String getLabel() {
            return label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public String getQuery() {
            return query;
        }

        public void setQuery(String query) {
            this.query = query;
        }

        public Integer getRowCount() {
            return rowCount;
        }

        public void setRowCount(Integer rowCount) {
            this.rowCount = rowCount;
        }

        public String getErrorMsg() {
            return errorMsg;
        }

        public void setErrorMsg(String errorMsg) {
            this.errorMsg = errorMsg;
        }
    }
}
