package ai.waii.clients.query;

import java.util.List;

import com.google.gson.annotations.SerializedName;

import ai.waii.clients.database.SearchContext;

public class DescribeQueryRequest {
    @SerializedName("search_context") private List<SearchContext> searchContext;
    @SerializedName("current_schema") private String currentSchema;
    private String query;

    public DescribeQueryRequest(List<SearchContext> searchContext, String currentSchema, String query) {
        this.searchContext = searchContext;
        this.currentSchema = currentSchema;
        this.query = query;
    }

    public DescribeQueryRequest() {
    }

    public List<SearchContext> getSearchContext() {
        return searchContext;
    }

    public DescribeQueryRequest setSearchContext(List<SearchContext> searchContext) {
        this.searchContext = searchContext;
        return this;
    }

    public String getCurrentSchema() {
        return currentSchema;
    }

    public void setCurrentSchema(String currentSchema) {
        this.currentSchema = currentSchema;
    }

    public String getQuery() {
        return query;
    }

    public DescribeQueryRequest setQuery(String query) {
        this.query = query;
        return this;
    }
}
