package ai.waii.clients.query;

import java.util.List;

import com.google.gson.annotations.SerializedName;

import ai.waii.clients.database.SearchContext;

public class DiffQueryRequest {
    @SerializedName("search_context") private List<SearchContext> searchContext;
    @SerializedName("current_schema") private String currentSchema;
    private String query;
    @SerializedName("previous_query") private String previousQuery;

    public DiffQueryRequest(List<SearchContext> searchContext, String currentSchema, String query, String previousQuery) {
        this.searchContext = searchContext;
        this.currentSchema = currentSchema;
        this.query = query;
        this.previousQuery = previousQuery;
    }

    public DiffQueryRequest() {
    }

    public List<SearchContext> getSearchContext() {
        return searchContext;
    }

    public DiffQueryRequest setSearchContext(List<SearchContext> searchContext) {
        this.searchContext = searchContext;
        return this;
    }

    public String getCurrentSchema() {
        return currentSchema;
    }

    public DiffQueryRequest setCurrentSchema(String currentSchema) {
        this.currentSchema = currentSchema;
        return this;
    }

    public String getQuery() {
        return query;
    }

    public DiffQueryRequest setQuery(String query) {
        this.query = query;
        return this;
    }

    public String getPreviousQuery() {
        return previousQuery;
    }

    public DiffQueryRequest setPreviousQuery(String previousQuery) {
        this.previousQuery = previousQuery;
        return this;
    }
}
