package ai.waii.clients.query;

import java.util.Map;

import com.google.gson.annotations.SerializedName;

import ai.waii.clients.database.SearchContext;
import waii.ai.clients.LLMBasedRequest;

public class QueryGenerationRequest extends LLMBasedRequest {

    @SerializedName("search_context")
    private SearchContext[] searchContext;
    @SerializedName("tweak_history")
    private Tweak[] tweakHistory;
    private String ask;
    private String uuid;
    private String dialect;
    @SerializedName("parent_uuid")
    private String parentUuid;
    private Map<String, Object> flags;
    @SerializedName("use_example_queries")
    private Boolean useExampleQueries;


    public SearchContext[] getSearchContext() {
        return searchContext;
    }

    public QueryGenerationRequest setSearchContext(SearchContext[] searchContext) {
        this.searchContext = searchContext;
        return this;
    }

    public Tweak[] getTweakHistory() {
        return tweakHistory;
    }

    public QueryGenerationRequest setTweakHistory(Tweak[] tweakHistory) {
        this.tweakHistory = tweakHistory;
        return this;
    }

    public String getAsk() {
        return ask;
    }

    public QueryGenerationRequest setAsk(String ask) {
        this.ask = ask;
        return this;
    }

    public String getUuid() {
        return uuid;
    }

    public QueryGenerationRequest setUuid(String uuid) {
        this.uuid = uuid;
        return this;
    }

    public String getDialect() {
        return dialect;
    }

    public QueryGenerationRequest setDialect(String dialect) {
        this.dialect = dialect;
        return this;
    }

    public String getParentUuid() {
        return parentUuid;
    }

    public QueryGenerationRequest setParentUuid(String parentUuid) {
        this.parentUuid = parentUuid;
        return this;
    }

    public Map<String, Object> getFlags() {
        return flags;
    }

    public QueryGenerationRequest setFlags(Map<String, Object> flags) {
        this.flags = flags;
        return this;
    }

    public Boolean getUseExampleQueries() {
        return useExampleQueries;
    }

    public QueryGenerationRequest setUseExampleQueries(Boolean useExampleQueries) {
        this.useExampleQueries = useExampleQueries;
        return this;
    }
}