package ai.waii.clients.query;

import java.util.List;

import com.google.gson.annotations.SerializedName;

public class QueryPerformanceResponse {

    private List<String> summary;
    private List<String> recommendations;
    @SerializedName("query_text") private String queryText;
    @SerializedName("execution_time_ms") private Long executionTimeMs;
    @SerializedName("compilation_time_ms") private Long compilationTimeMs;

    public QueryPerformanceResponse(List<String> summary, List<String> recommendations, String queryText, Long executionTimeMs, Long compilationTimeMs) {
        this.summary = summary;
        this.recommendations = recommendations;
        this.queryText = queryText;
        this.executionTimeMs = executionTimeMs;
        this.compilationTimeMs = compilationTimeMs;
    }

    // Getters and Setters
    public List<String> getSummary() {
        return summary;
    }

    public void setSummary(List<String> summary) {
        this.summary = summary;
    }

    public List<String> getRecommendations() {
        return recommendations;
    }

    public void setRecommendations(List<String> recommendations) {
        this.recommendations = recommendations;
    }

    public String getQueryText() {
        return queryText;
    }

    public void setQueryText(String queryText) {
        this.queryText = queryText;
    }

    public Long getExecutionTimeMs() {
        return executionTimeMs;
    }

    public void setExecutionTimeMs(Long executionTimeMs) {
        this.executionTimeMs = executionTimeMs;
    }

    public Long getCompilationTimeMs() {
        return compilationTimeMs;
    }

    public void setCompilationTimeMs(Long compilationTimeMs) {
        this.compilationTimeMs = compilationTimeMs;
    }
}
