package ai.waii.clients.query;

import java.util.Map;

import ai.waii.clients.database.SchemaName;

public class RunQueryRequest {
    private String query;
    private String sessionId;
    private SchemaName currentSchema;
    private Map<String, Object> sessionParameters;

    public RunQueryRequest(String query, String sessionId, SchemaName currentSchema, Map<String, Object> sessionParameters) {
        this.query = query;
        this.sessionId = sessionId;
        this.currentSchema = currentSchema;
        this.sessionParameters = sessionParameters;
    }

    public RunQueryRequest() {
    }

    public String getQuery() {
        return query;
    }

    public RunQueryRequest setQuery(String query) {
        this.query = query;
        return this;
    }

    public String getSessionId() {
        return sessionId;
    }

    public RunQueryRequest setSessionId(String sessionId) {
        this.sessionId = sessionId;
        return this;
    }

    public SchemaName getCurrentSchema() {
        return currentSchema;
    }

    public RunQueryRequest setCurrentSchema(SchemaName currentSchema) {
        this.currentSchema = currentSchema;
        return this;
    }

    public Map<String, Object> getSessionParameters() {
        return sessionParameters;
    }

    public RunQueryRequest setSessionParameters(Map<String, Object> sessionParameters) {
        this.sessionParameters = sessionParameters;
        return this;
    }
}
