package ai.waii.clients.query;

import java.util.List;

import com.google.gson.annotations.SerializedName;

import ai.waii.clients.database.SearchContext;
import waii.ai.clients.LLMBasedRequest;

public class TranscodeQueryRequest extends LLMBasedRequest {
    @SerializedName("search_context") private List<SearchContext> searchContext;
    private String ask;
    @SerializedName("source_dialect") private String sourceDialect;
    @SerializedName("source_query") private String sourceQuery;
    @SerializedName("target_dialect") private String targetDialect;

    public TranscodeQueryRequest(List<SearchContext> searchContext, String ask, String sourceDialect, String sourceQuery, String targetDialect) {
        this.searchContext = searchContext;
        this.ask = ask;
        this.sourceDialect = sourceDialect;
        this.sourceQuery = sourceQuery;
        this.targetDialect = targetDialect;
    }

    public TranscodeQueryRequest() {
    }

    public List<SearchContext> getSearchContext() {
        return searchContext;
    }

    public TranscodeQueryRequest setSearchContext(List<SearchContext> searchContext) {
        this.searchContext = searchContext;
        return this;
    }

    public String getAsk() {
        return ask;
    }

    public TranscodeQueryRequest setAsk(String ask) {
        this.ask = ask;
        return this;
    }

    public String getSourceDialect() {
        return sourceDialect;
    }

    public TranscodeQueryRequest setSourceDialect(String sourceDialect) {
        this.sourceDialect = sourceDialect;
        return this;
    }

    public String getSourceQuery() {
        return sourceQuery;
    }

    public TranscodeQueryRequest setSourceQuery(String sourceQuery) {
        this.sourceQuery = sourceQuery;
        return this;
    }

    public String getTargetDialect() {
        return targetDialect;
    }

    public TranscodeQueryRequest setTargetDialect(String targetDialect) {
        this.targetDialect = targetDialect;
        return this;
    }
}
