package ai.waii.clients.semanticcontext;

import java.util.UUID;
import java.util.List;

import com.google.gson.annotations.SerializedName;

public class SemanticStatement {
    private String id;
    private String scope;
    private String statement;
    private String[] labels;
    @SerializedName("always_include") private Boolean alwaysInclude;
    @SerializedName("lookup_summaries") private String[] lookupSummaries;
    @SerializedName("summarization_prompt") private String summarizationPrompt;
    private Boolean critical;

    private Boolean enabled;
    private List<SemanticStatementWarning> warnings;
    @SerializedName("user_id") private String userId;
    @SerializedName("tenant_id") private String tenantId;
    @SerializedName("org_id") private String orgId;

    public SemanticStatement() {
        this.scope = "*";
        this.labels = new String[]{};
        this.alwaysInclude = true;
        this.lookupSummaries = new String[]{};
        this.summarizationPrompt = "";
        this.id = UUID.randomUUID().toString();
        this.critical = false;
        this.enabled = true;
        this.warnings = null;
        this.userId = "*";
        this.tenantId = "*";
        this.orgId = "*";
    }

    public SemanticStatement(
            String scope, String statement, String[] labels, Boolean alwaysInclude,
            String[] lookupSummaries, String summarizationPrompt, String id, Boolean critical) {
        this.scope = scope;
        this.statement = statement;
        this.labels = labels;
        this.alwaysInclude = alwaysInclude;
        this.lookupSummaries = lookupSummaries;
        this.summarizationPrompt = summarizationPrompt;
        this.critical = critical;
        if (id != null && !id.isEmpty()) {
            this.id = id;
        } else {
            this.id = UUID.randomUUID().toString();
        }
        this.enabled = true;
        this.warnings = null;
        this.userId = "*";
        this.tenantId = "*";
        this.orgId = "*";
    }

    public String getId() {
        return id;
    }

    public SemanticStatement setId(String id) {
        this.id = id;
        return this;
    }

    public String getScope() {
        return scope;
    }

    public SemanticStatement setScope(String scope) {
        this.scope = scope;
        return this;
    }

    public String getStatement() {
        return statement;
    }

    public SemanticStatement setStatement(String statement) {
        this.statement = statement;
        return this;
    }

    public String[] getLabels() {
        return labels;
    }

    public SemanticStatement setLabels(String[] labels) {
        this.labels = labels;
        return this;
    }

    public Boolean getAlwaysInclude() {
        return alwaysInclude;
    }

    public SemanticStatement setAlwaysInclude(Boolean alwaysInclude) {
        this.alwaysInclude = alwaysInclude;
        return this;
    }

    public Boolean getCritical() {
        return critical;
    }

    public SemanticStatement setCritical(Boolean critical) {
        this.critical = critical;
        return this;
    }

    public String[] getLookupSummaries() {
        return lookupSummaries;
    }

    public SemanticStatement setLookupSummaries(String[] lookupSummaries) {
        this.lookupSummaries = lookupSummaries;
        return this;
    }

    public String getSummarizationPrompt() {
        return summarizationPrompt;
    }

    public SemanticStatement setSummarizationPrompt(String summarizationPrompt) {
        this.summarizationPrompt = summarizationPrompt;
        return this;
    }

    public Boolean getEnabled() {
        return enabled;
    }

    public SemanticStatement setEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public List<SemanticStatementWarning> getWarnings() {
        return warnings;
    }

    public SemanticStatement setWarnings(List<SemanticStatementWarning> warnings) {
        this.warnings = warnings;
        return this;
    }

    public String getUserId() {
        return userId;
    }

    public SemanticStatement setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public String getTenantId() {
        return tenantId;
    }

    public SemanticStatement setTenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public String getOrgId() {
        return orgId;
    }

    public SemanticStatement setOrgId(String orgId) {
        this.orgId = orgId;
        return this;
    }

    public static class SemanticStatementWarning {
        private String message;
        private String type;

        public SemanticStatementWarning() {
        }

        public SemanticStatementWarning(String message, String type) {
            this.message = message;
            this.type = type;
        }

        public String getMessage() {
            return message;
        }

        public SemanticStatementWarning setMessage(String message) {
            this.message = message;
            return this;
        }

        public String getType() {
            return type;
        }

        public SemanticStatementWarning setType(String type) {
            this.type = type;
            return this;
        }
    }
}