package ai.waii.clients.user;

import java.io.IOException;

import com.google.gson.Gson;

import ai.waii.WaiiHttpClient;

public class User {

    private final WaiiHttpClient httpClient;
    private static final String GET_ENDPOINT = "get-user-info";

    public User(WaiiHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public GetUserInfoResponse getInfo(GetUserInfoRequest params) throws IOException {
        String jsonParams = new Gson().toJson(params); // Assuming params might later include fields
        return this.httpClient.commonFetch(GET_ENDPOINT, jsonParams, GetUserInfoResponse.class);
    }
}
