/*
 * WhyLabs API client
 * WhyLabs API that enables end-to-end AI observability
 *
 * The version of the OpenAPI document: 0.1
 * Contact: support@whylabs.ai
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package ai.whylabs.service.api;

import ai.whylabs.service.invoker.ApiCallback;
import ai.whylabs.service.invoker.ApiClient;
import ai.whylabs.service.invoker.ApiException;
import ai.whylabs.service.invoker.ApiResponse;
import ai.whylabs.service.invoker.Configuration;
import ai.whylabs.service.invoker.Pair;
import ai.whylabs.service.invoker.ProgressRequestBody;
import ai.whylabs.service.invoker.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import ai.whylabs.service.model.UserApiKey;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ApiKeyApi {
    private ApiClient localVarApiClient;

    public ApiKeyApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ApiKeyApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    /**
     * Build call for createApiKey
     * @param orgId Your company&#39;s unique organization ID (required)
     * @param userId The unique user ID in an organization. (required)
     * @param expirationTime Expiration time in epoch milliseconds (optional)
     * @param scopes Scopes of the token  An object with key ID and other metadata about the key (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> A object with key ID and other metadata about the key </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createApiKeyCall(String orgId, String userId, Long expirationTime, List<String> scopes, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v0/organizations/{org_id}/api-key"
            .replaceAll("\\{" + "org_id" + "\\}", localVarApiClient.escapeString(orgId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (userId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("user_id", userId));
        }

        if (expirationTime != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("expiration_time", expirationTime));
        }

        if (scopes != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("multi", "scopes", scopes));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "ApiKeyAuth" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createApiKeyValidateBeforeCall(String orgId, String userId, Long expirationTime, List<String> scopes, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'orgId' is set
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling createApiKey(Async)");
        }
        
        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling createApiKey(Async)");
        }
        

        okhttp3.Call localVarCall = createApiKeyCall(orgId, userId, expirationTime, scopes, _callback);
        return localVarCall;

    }

    /**
     * Generate an API key for a user.
     * Generates an API key for a given user. Must be called either by system administrator or by the user themselves
     * @param orgId Your company&#39;s unique organization ID (required)
     * @param userId The unique user ID in an organization. (required)
     * @param expirationTime Expiration time in epoch milliseconds (optional)
     * @param scopes Scopes of the token  An object with key ID and other metadata about the key (optional)
     * @return UserApiKey
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> A object with key ID and other metadata about the key </td><td>  -  </td></tr>
     </table>
     */
    public UserApiKey createApiKey(String orgId, String userId, Long expirationTime, List<String> scopes) throws ApiException {
        ApiResponse<UserApiKey> localVarResp = createApiKeyWithHttpInfo(orgId, userId, expirationTime, scopes);
        return localVarResp.getData();
    }

    /**
     * Generate an API key for a user.
     * Generates an API key for a given user. Must be called either by system administrator or by the user themselves
     * @param orgId Your company&#39;s unique organization ID (required)
     * @param userId The unique user ID in an organization. (required)
     * @param expirationTime Expiration time in epoch milliseconds (optional)
     * @param scopes Scopes of the token  An object with key ID and other metadata about the key (optional)
     * @return ApiResponse&lt;UserApiKey&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> A object with key ID and other metadata about the key </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<UserApiKey> createApiKeyWithHttpInfo(String orgId, String userId, Long expirationTime, List<String> scopes) throws ApiException {
        okhttp3.Call localVarCall = createApiKeyValidateBeforeCall(orgId, userId, expirationTime, scopes, null);
        Type localVarReturnType = new TypeToken<UserApiKey>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Generate an API key for a user. (asynchronously)
     * Generates an API key for a given user. Must be called either by system administrator or by the user themselves
     * @param orgId Your company&#39;s unique organization ID (required)
     * @param userId The unique user ID in an organization. (required)
     * @param expirationTime Expiration time in epoch milliseconds (optional)
     * @param scopes Scopes of the token  An object with key ID and other metadata about the key (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> A object with key ID and other metadata about the key </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createApiKeyAsync(String orgId, String userId, Long expirationTime, List<String> scopes, final ApiCallback<UserApiKey> _callback) throws ApiException {

        okhttp3.Call localVarCall = createApiKeyValidateBeforeCall(orgId, userId, expirationTime, scopes, _callback);
        Type localVarReturnType = new TypeToken<UserApiKey>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
