/*
 * WhyLabs API client
 * WhyLabs API that enables end-to-end AI observability
 *
 * The version of the OpenAPI document: 0.1
 * Contact: support@whylabs.ai
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package ai.whylabs.service.api;

import ai.whylabs.service.invoker.ApiCallback;
import ai.whylabs.service.invoker.ApiClient;
import ai.whylabs.service.invoker.ApiException;
import ai.whylabs.service.invoker.ApiResponse;
import ai.whylabs.service.invoker.Configuration;
import ai.whylabs.service.invoker.Pair;
import ai.whylabs.service.invoker.ProgressRequestBody;
import ai.whylabs.service.invoker.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import ai.whylabs.service.model.ListModelsResponse;
import ai.whylabs.service.model.ListSegmentsResponse;
import ai.whylabs.service.model.ModelMetadata;
import ai.whylabs.service.model.ModelSummary;
import ai.whylabs.service.model.TimePeriod;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ModelsApi {
    private ApiClient localVarApiClient;

    public ModelsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ModelsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    /**
     * Build call for createModel
     * @param orgId The organization ID (required)
     * @param modelName The name of a model (required)
     * @param timePeriod The [TimePeriod] for data aggregation/alerting for a model (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> The model summary if succeeds </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createModelCall(String orgId, String modelName, TimePeriod timePeriod, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v0/organizations/{org_id}/models"
            .replaceAll("\\{" + "org_id" + "\\}", localVarApiClient.escapeString(orgId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (modelName != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("model_name", modelName));
        }

        if (timePeriod != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("time_period", timePeriod));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "ApiKeyAuth" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createModelValidateBeforeCall(String orgId, String modelName, TimePeriod timePeriod, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'orgId' is set
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling createModel(Async)");
        }
        
        // verify the required parameter 'modelName' is set
        if (modelName == null) {
            throw new ApiException("Missing the required parameter 'modelName' when calling createModel(Async)");
        }
        
        // verify the required parameter 'timePeriod' is set
        if (timePeriod == null) {
            throw new ApiException("Missing the required parameter 'timePeriod' when calling createModel(Async)");
        }
        

        okhttp3.Call localVarCall = createModelCall(orgId, modelName, timePeriod, _callback);
        return localVarCall;

    }

    /**
     * Create a model with a given name and a time period
     * Create a model
     * @param orgId The organization ID (required)
     * @param modelName The name of a model (required)
     * @param timePeriod The [TimePeriod] for data aggregation/alerting for a model (required)
     * @return ModelSummary
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> The model summary if succeeds </td><td>  -  </td></tr>
     </table>
     */
    public ModelSummary createModel(String orgId, String modelName, TimePeriod timePeriod) throws ApiException {
        ApiResponse<ModelSummary> localVarResp = createModelWithHttpInfo(orgId, modelName, timePeriod);
        return localVarResp.getData();
    }

    /**
     * Create a model with a given name and a time period
     * Create a model
     * @param orgId The organization ID (required)
     * @param modelName The name of a model (required)
     * @param timePeriod The [TimePeriod] for data aggregation/alerting for a model (required)
     * @return ApiResponse&lt;ModelSummary&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> The model summary if succeeds </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<ModelSummary> createModelWithHttpInfo(String orgId, String modelName, TimePeriod timePeriod) throws ApiException {
        okhttp3.Call localVarCall = createModelValidateBeforeCall(orgId, modelName, timePeriod, null);
        Type localVarReturnType = new TypeToken<ModelSummary>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Create a model with a given name and a time period (asynchronously)
     * Create a model
     * @param orgId The organization ID (required)
     * @param modelName The name of a model (required)
     * @param timePeriod The [TimePeriod] for data aggregation/alerting for a model (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> The model summary if succeeds </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createModelAsync(String orgId, String modelName, TimePeriod timePeriod, final ApiCallback<ModelSummary> _callback) throws ApiException {

        okhttp3.Call localVarCall = createModelValidateBeforeCall(orgId, modelName, timePeriod, _callback);
        Type localVarReturnType = new TypeToken<ModelSummary>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getModel
     * @param orgId The name of an organization (required)
     * @param modelId The ID of a model (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> A [ModelMetadata] object if succeeds </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getModelCall(String orgId, String modelId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v0/organizations/{org_id}/models/{model_id}"
            .replaceAll("\\{" + "org_id" + "\\}", localVarApiClient.escapeString(orgId.toString()))
            .replaceAll("\\{" + "model_id" + "\\}", localVarApiClient.escapeString(modelId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "ApiKeyAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getModelValidateBeforeCall(String orgId, String modelId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'orgId' is set
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling getModel(Async)");
        }
        
        // verify the required parameter 'modelId' is set
        if (modelId == null) {
            throw new ApiException("Missing the required parameter 'modelId' when calling getModel(Async)");
        }
        

        okhttp3.Call localVarCall = getModelCall(orgId, modelId, _callback);
        return localVarCall;

    }

    /**
     * Get a model metadata
     * Returns various metadata about a model
     * @param orgId The name of an organization (required)
     * @param modelId The ID of a model (required)
     * @return ModelMetadata
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> A [ModelMetadata] object if succeeds </td><td>  -  </td></tr>
     </table>
     */
    public ModelMetadata getModel(String orgId, String modelId) throws ApiException {
        ApiResponse<ModelMetadata> localVarResp = getModelWithHttpInfo(orgId, modelId);
        return localVarResp.getData();
    }

    /**
     * Get a model metadata
     * Returns various metadata about a model
     * @param orgId The name of an organization (required)
     * @param modelId The ID of a model (required)
     * @return ApiResponse&lt;ModelMetadata&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> A [ModelMetadata] object if succeeds </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<ModelMetadata> getModelWithHttpInfo(String orgId, String modelId) throws ApiException {
        okhttp3.Call localVarCall = getModelValidateBeforeCall(orgId, modelId, null);
        Type localVarReturnType = new TypeToken<ModelMetadata>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get a model metadata (asynchronously)
     * Returns various metadata about a model
     * @param orgId The name of an organization (required)
     * @param modelId The ID of a model (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> A [ModelMetadata] object if succeeds </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getModelAsync(String orgId, String modelId, final ApiCallback<ModelMetadata> _callback) throws ApiException {

        okhttp3.Call localVarCall = getModelValidateBeforeCall(orgId, modelId, _callback);
        Type localVarReturnType = new TypeToken<ModelMetadata>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listModels
     * @param orgId Your company&#39;s unique organization ID (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> A list of model summary items </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listModelsCall(String orgId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v0/organizations/{org_id}/models"
            .replaceAll("\\{" + "org_id" + "\\}", localVarApiClient.escapeString(orgId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "ApiKeyAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listModelsValidateBeforeCall(String orgId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'orgId' is set
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling listModels(Async)");
        }
        

        okhttp3.Call localVarCall = listModelsCall(orgId, _callback);
        return localVarCall;

    }

    /**
     * Get a list of all of the model ids for an organization.
     * Get a list of all of the model ids for an organization.
     * @param orgId Your company&#39;s unique organization ID (required)
     * @return ListModelsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> A list of model summary items </td><td>  -  </td></tr>
     </table>
     */
    public ListModelsResponse listModels(String orgId) throws ApiException {
        ApiResponse<ListModelsResponse> localVarResp = listModelsWithHttpInfo(orgId);
        return localVarResp.getData();
    }

    /**
     * Get a list of all of the model ids for an organization.
     * Get a list of all of the model ids for an organization.
     * @param orgId Your company&#39;s unique organization ID (required)
     * @return ApiResponse&lt;ListModelsResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> A list of model summary items </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<ListModelsResponse> listModelsWithHttpInfo(String orgId) throws ApiException {
        okhttp3.Call localVarCall = listModelsValidateBeforeCall(orgId, null);
        Type localVarReturnType = new TypeToken<ListModelsResponse>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get a list of all of the model ids for an organization. (asynchronously)
     * Get a list of all of the model ids for an organization.
     * @param orgId Your company&#39;s unique organization ID (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> A list of model summary items </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listModelsAsync(String orgId, final ApiCallback<ListModelsResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = listModelsValidateBeforeCall(orgId, _callback);
        Type localVarReturnType = new TypeToken<ListModelsResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listSegments
     * @param orgId The name of an organization (required)
     * @param modelId The ID of a model (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> A [ListSegmentsResponse] object if succeeds </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listSegmentsCall(String orgId, String modelId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v0/organizations/{org_id}/models/{model_id}/segments"
            .replaceAll("\\{" + "org_id" + "\\}", localVarApiClient.escapeString(orgId.toString()))
            .replaceAll("\\{" + "model_id" + "\\}", localVarApiClient.escapeString(modelId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "ApiKeyAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listSegmentsValidateBeforeCall(String orgId, String modelId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'orgId' is set
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling listSegments(Async)");
        }
        
        // verify the required parameter 'modelId' is set
        if (modelId == null) {
            throw new ApiException("Missing the required parameter 'modelId' when calling listSegments(Async)");
        }
        

        okhttp3.Call localVarCall = listSegmentsCall(orgId, modelId, _callback);
        return localVarCall;

    }

    /**
     * Get a model metadata
     * Returns the list of Segments for a given model
     * @param orgId The name of an organization (required)
     * @param modelId The ID of a model (required)
     * @return ListSegmentsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> A [ListSegmentsResponse] object if succeeds </td><td>  -  </td></tr>
     </table>
     */
    public ListSegmentsResponse listSegments(String orgId, String modelId) throws ApiException {
        ApiResponse<ListSegmentsResponse> localVarResp = listSegmentsWithHttpInfo(orgId, modelId);
        return localVarResp.getData();
    }

    /**
     * Get a model metadata
     * Returns the list of Segments for a given model
     * @param orgId The name of an organization (required)
     * @param modelId The ID of a model (required)
     * @return ApiResponse&lt;ListSegmentsResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> A [ListSegmentsResponse] object if succeeds </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<ListSegmentsResponse> listSegmentsWithHttpInfo(String orgId, String modelId) throws ApiException {
        okhttp3.Call localVarCall = listSegmentsValidateBeforeCall(orgId, modelId, null);
        Type localVarReturnType = new TypeToken<ListSegmentsResponse>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get a model metadata (asynchronously)
     * Returns the list of Segments for a given model
     * @param orgId The name of an organization (required)
     * @param modelId The ID of a model (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> A [ListSegmentsResponse] object if succeeds </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listSegmentsAsync(String orgId, String modelId, final ApiCallback<ListSegmentsResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = listSegmentsValidateBeforeCall(orgId, modelId, _callback);
        Type localVarReturnType = new TypeToken<ListSegmentsResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
