/*
 * Decompiled with CFR 0.152.
 */
package ai.whylabs.service.api;

import ai.whylabs.service.invoker.ApiCallback;
import ai.whylabs.service.invoker.ApiClient;
import ai.whylabs.service.invoker.ApiException;
import ai.whylabs.service.invoker.ApiResponse;
import ai.whylabs.service.invoker.Configuration;
import ai.whylabs.service.invoker.Pair;
import ai.whylabs.service.model.ListUserApiKeys;
import ai.whylabs.service.model.UserApiKey;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;

public class ApiKeyApi {
    private ApiClient localVarApiClient;

    public ApiKeyApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ApiKeyApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call createApiKeyCall(String orgId, String userId, Long expirationTime, List<String> scopes, String alias, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/v0/organizations/{org_id}/api-key".replaceAll("\\{org_id\\}", this.localVarApiClient.escapeString(orgId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (userId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("user_id", userId));
        }
        if (expirationTime != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("expiration_time", expirationTime));
        }
        if (scopes != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "scopes", scopes));
        }
        if (alias != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("alias", alias));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"ApiKeyAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createApiKeyValidateBeforeCall(String orgId, String userId, Long expirationTime, List<String> scopes, String alias, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling createApiKey(Async)");
        }
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling createApiKey(Async)");
        }
        Call localVarCall = this.createApiKeyCall(orgId, userId, expirationTime, scopes, alias, _callback);
        return localVarCall;
    }

    public UserApiKey createApiKey(String orgId, String userId, Long expirationTime, List<String> scopes, String alias) throws ApiException {
        ApiResponse<UserApiKey> localVarResp = this.createApiKeyWithHttpInfo(orgId, userId, expirationTime, scopes, alias);
        return localVarResp.getData();
    }

    public ApiResponse<UserApiKey> createApiKeyWithHttpInfo(String orgId, String userId, Long expirationTime, List<String> scopes, String alias) throws ApiException {
        Call localVarCall = this.createApiKeyValidateBeforeCall(orgId, userId, expirationTime, scopes, alias, null);
        Type localVarReturnType = new TypeToken<UserApiKey>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createApiKeyAsync(String orgId, String userId, Long expirationTime, List<String> scopes, String alias, ApiCallback<UserApiKey> _callback) throws ApiException {
        Call localVarCall = this.createApiKeyValidateBeforeCall(orgId, userId, expirationTime, scopes, alias, _callback);
        Type localVarReturnType = new TypeToken<UserApiKey>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listApiKeysCall(String orgId, String userId, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/v0/organizations/{org_id}/api-key".replaceAll("\\{org_id\\}", this.localVarApiClient.escapeString(orgId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (userId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("user_id", userId));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"ApiKeyAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listApiKeysValidateBeforeCall(String orgId, String userId, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling listApiKeys(Async)");
        }
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling listApiKeys(Async)");
        }
        Call localVarCall = this.listApiKeysCall(orgId, userId, _callback);
        return localVarCall;
    }

    public ListUserApiKeys listApiKeys(String orgId, String userId) throws ApiException {
        ApiResponse<ListUserApiKeys> localVarResp = this.listApiKeysWithHttpInfo(orgId, userId);
        return localVarResp.getData();
    }

    public ApiResponse<ListUserApiKeys> listApiKeysWithHttpInfo(String orgId, String userId) throws ApiException {
        Call localVarCall = this.listApiKeysValidateBeforeCall(orgId, userId, null);
        Type localVarReturnType = new TypeToken<ListUserApiKeys>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listApiKeysAsync(String orgId, String userId, ApiCallback<ListUserApiKeys> _callback) throws ApiException {
        Call localVarCall = this.listApiKeysValidateBeforeCall(orgId, userId, _callback);
        Type localVarReturnType = new TypeToken<ListUserApiKeys>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call revokeApiKeyCall(String orgId, String userId, String keyId, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/v0/organizations/{org_id}/api-key".replaceAll("\\{org_id\\}", this.localVarApiClient.escapeString(orgId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (userId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("user_id", userId));
        }
        if (keyId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("key_id", keyId));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"ApiKeyAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call revokeApiKeyValidateBeforeCall(String orgId, String userId, String keyId, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling revokeApiKey(Async)");
        }
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling revokeApiKey(Async)");
        }
        if (keyId == null) {
            throw new ApiException("Missing the required parameter 'keyId' when calling revokeApiKey(Async)");
        }
        Call localVarCall = this.revokeApiKeyCall(orgId, userId, keyId, _callback);
        return localVarCall;
    }

    public UserApiKey revokeApiKey(String orgId, String userId, String keyId) throws ApiException {
        ApiResponse<UserApiKey> localVarResp = this.revokeApiKeyWithHttpInfo(orgId, userId, keyId);
        return localVarResp.getData();
    }

    public ApiResponse<UserApiKey> revokeApiKeyWithHttpInfo(String orgId, String userId, String keyId) throws ApiException {
        Call localVarCall = this.revokeApiKeyValidateBeforeCall(orgId, userId, keyId, null);
        Type localVarReturnType = new TypeToken<UserApiKey>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call revokeApiKeyAsync(String orgId, String userId, String keyId, ApiCallback<UserApiKey> _callback) throws ApiException {
        Call localVarCall = this.revokeApiKeyValidateBeforeCall(orgId, userId, keyId, _callback);
        Type localVarReturnType = new TypeToken<UserApiKey>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

