/*
 * WhyLabs API client
 * WhyLabs API that enables end-to-end AI observability
 *
 * The version of the OpenAPI document: 0.1
 * Contact: support@whylabs.ai
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package ai.whylabs.service.api;

import ai.whylabs.service.invoker.ApiCallback;
import ai.whylabs.service.invoker.ApiClient;
import ai.whylabs.service.invoker.ApiException;
import ai.whylabs.service.invoker.ApiResponse;
import ai.whylabs.service.invoker.Configuration;
import ai.whylabs.service.invoker.Pair;
import ai.whylabs.service.invoker.ProgressRequestBody;
import ai.whylabs.service.invoker.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import ai.whylabs.service.model.ListUserApiKeys;
import ai.whylabs.service.model.UserApiKey;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ApiKeyApi {
    private ApiClient localVarApiClient;

    public ApiKeyApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ApiKeyApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    /**
     * Build call for createApiKey
     * @param orgId Your company&#39;s unique organization ID (required)
     * @param userId The unique user ID in an organization. (required)
     * @param expirationTime Expiration time in epoch milliseconds (optional)
     * @param scopes Scopes of the token (optional)
     * @param alias A human-friendly name for the API Key  An object with key ID and other metadata about the key (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> A object with key ID and other metadata about the key </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createApiKeyCall(String orgId, String userId, Long expirationTime, List<String> scopes, String alias, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v0/organizations/{org_id}/api-key"
            .replaceAll("\\{" + "org_id" + "\\}", localVarApiClient.escapeString(orgId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (userId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("user_id", userId));
        }

        if (expirationTime != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("expiration_time", expirationTime));
        }

        if (scopes != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("multi", "scopes", scopes));
        }

        if (alias != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("alias", alias));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "ApiKeyAuth" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createApiKeyValidateBeforeCall(String orgId, String userId, Long expirationTime, List<String> scopes, String alias, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'orgId' is set
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling createApiKey(Async)");
        }
        
        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling createApiKey(Async)");
        }
        

        okhttp3.Call localVarCall = createApiKeyCall(orgId, userId, expirationTime, scopes, alias, _callback);
        return localVarCall;

    }

    /**
     * Generate an API key for a user.
     * Generates an API key for a given user. Must be called either by system administrator or by the user themselves
     * @param orgId Your company&#39;s unique organization ID (required)
     * @param userId The unique user ID in an organization. (required)
     * @param expirationTime Expiration time in epoch milliseconds (optional)
     * @param scopes Scopes of the token (optional)
     * @param alias A human-friendly name for the API Key  An object with key ID and other metadata about the key (optional)
     * @return UserApiKey
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> A object with key ID and other metadata about the key </td><td>  -  </td></tr>
     </table>
     */
    public UserApiKey createApiKey(String orgId, String userId, Long expirationTime, List<String> scopes, String alias) throws ApiException {
        ApiResponse<UserApiKey> localVarResp = createApiKeyWithHttpInfo(orgId, userId, expirationTime, scopes, alias);
        return localVarResp.getData();
    }

    /**
     * Generate an API key for a user.
     * Generates an API key for a given user. Must be called either by system administrator or by the user themselves
     * @param orgId Your company&#39;s unique organization ID (required)
     * @param userId The unique user ID in an organization. (required)
     * @param expirationTime Expiration time in epoch milliseconds (optional)
     * @param scopes Scopes of the token (optional)
     * @param alias A human-friendly name for the API Key  An object with key ID and other metadata about the key (optional)
     * @return ApiResponse&lt;UserApiKey&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> A object with key ID and other metadata about the key </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<UserApiKey> createApiKeyWithHttpInfo(String orgId, String userId, Long expirationTime, List<String> scopes, String alias) throws ApiException {
        okhttp3.Call localVarCall = createApiKeyValidateBeforeCall(orgId, userId, expirationTime, scopes, alias, null);
        Type localVarReturnType = new TypeToken<UserApiKey>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Generate an API key for a user. (asynchronously)
     * Generates an API key for a given user. Must be called either by system administrator or by the user themselves
     * @param orgId Your company&#39;s unique organization ID (required)
     * @param userId The unique user ID in an organization. (required)
     * @param expirationTime Expiration time in epoch milliseconds (optional)
     * @param scopes Scopes of the token (optional)
     * @param alias A human-friendly name for the API Key  An object with key ID and other metadata about the key (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> A object with key ID and other metadata about the key </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createApiKeyAsync(String orgId, String userId, Long expirationTime, List<String> scopes, String alias, final ApiCallback<UserApiKey> _callback) throws ApiException {

        okhttp3.Call localVarCall = createApiKeyValidateBeforeCall(orgId, userId, expirationTime, scopes, alias, _callback);
        Type localVarReturnType = new TypeToken<UserApiKey>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listApiKeys
     * @param orgId Your company&#39;s unique organization ID (required)
     * @param userId The unique user ID in an organization.  A list of objects with key ID and other metadata about the keys, but no secret values (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> A list of objects with key ID and other metadata about the keys, but no secret values </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listApiKeysCall(String orgId, String userId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v0/organizations/{org_id}/api-key"
            .replaceAll("\\{" + "org_id" + "\\}", localVarApiClient.escapeString(orgId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (userId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("user_id", userId));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "ApiKeyAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listApiKeysValidateBeforeCall(String orgId, String userId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'orgId' is set
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling listApiKeys(Async)");
        }
        
        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling listApiKeys(Async)");
        }
        

        okhttp3.Call localVarCall = listApiKeysCall(orgId, userId, _callback);
        return localVarCall;

    }

    /**
     * List API key metadata for a given organization and user
     * Returns the API key metadata for a given organization and user
     * @param orgId Your company&#39;s unique organization ID (required)
     * @param userId The unique user ID in an organization.  A list of objects with key ID and other metadata about the keys, but no secret values (required)
     * @return ListUserApiKeys
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> A list of objects with key ID and other metadata about the keys, but no secret values </td><td>  -  </td></tr>
     </table>
     */
    public ListUserApiKeys listApiKeys(String orgId, String userId) throws ApiException {
        ApiResponse<ListUserApiKeys> localVarResp = listApiKeysWithHttpInfo(orgId, userId);
        return localVarResp.getData();
    }

    /**
     * List API key metadata for a given organization and user
     * Returns the API key metadata for a given organization and user
     * @param orgId Your company&#39;s unique organization ID (required)
     * @param userId The unique user ID in an organization.  A list of objects with key ID and other metadata about the keys, but no secret values (required)
     * @return ApiResponse&lt;ListUserApiKeys&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> A list of objects with key ID and other metadata about the keys, but no secret values </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<ListUserApiKeys> listApiKeysWithHttpInfo(String orgId, String userId) throws ApiException {
        okhttp3.Call localVarCall = listApiKeysValidateBeforeCall(orgId, userId, null);
        Type localVarReturnType = new TypeToken<ListUserApiKeys>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List API key metadata for a given organization and user (asynchronously)
     * Returns the API key metadata for a given organization and user
     * @param orgId Your company&#39;s unique organization ID (required)
     * @param userId The unique user ID in an organization.  A list of objects with key ID and other metadata about the keys, but no secret values (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> A list of objects with key ID and other metadata about the keys, but no secret values </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listApiKeysAsync(String orgId, String userId, final ApiCallback<ListUserApiKeys> _callback) throws ApiException {

        okhttp3.Call localVarCall = listApiKeysValidateBeforeCall(orgId, userId, _callback);
        Type localVarReturnType = new TypeToken<ListUserApiKeys>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for revokeApiKey
     * @param orgId  (required)
     * @param userId  (required)
     * @param keyId ID of the key to revoke  Metadata for the revoked API Key (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> Revoked API Key&#39;s metadata </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call revokeApiKeyCall(String orgId, String userId, String keyId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v0/organizations/{org_id}/api-key"
            .replaceAll("\\{" + "org_id" + "\\}", localVarApiClient.escapeString(orgId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (userId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("user_id", userId));
        }

        if (keyId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("key_id", keyId));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "ApiKeyAuth" };
        return localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call revokeApiKeyValidateBeforeCall(String orgId, String userId, String keyId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'orgId' is set
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling revokeApiKey(Async)");
        }
        
        // verify the required parameter 'userId' is set
        if (userId == null) {
            throw new ApiException("Missing the required parameter 'userId' when calling revokeApiKey(Async)");
        }
        
        // verify the required parameter 'keyId' is set
        if (keyId == null) {
            throw new ApiException("Missing the required parameter 'keyId' when calling revokeApiKey(Async)");
        }
        

        okhttp3.Call localVarCall = revokeApiKeyCall(orgId, userId, keyId, _callback);
        return localVarCall;

    }

    /**
     * Revoke the given API Key, removing its ability to access WhyLabs systems
     * Revokes the given API Key
     * @param orgId  (required)
     * @param userId  (required)
     * @param keyId ID of the key to revoke  Metadata for the revoked API Key (required)
     * @return UserApiKey
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> Revoked API Key&#39;s metadata </td><td>  -  </td></tr>
     </table>
     */
    public UserApiKey revokeApiKey(String orgId, String userId, String keyId) throws ApiException {
        ApiResponse<UserApiKey> localVarResp = revokeApiKeyWithHttpInfo(orgId, userId, keyId);
        return localVarResp.getData();
    }

    /**
     * Revoke the given API Key, removing its ability to access WhyLabs systems
     * Revokes the given API Key
     * @param orgId  (required)
     * @param userId  (required)
     * @param keyId ID of the key to revoke  Metadata for the revoked API Key (required)
     * @return ApiResponse&lt;UserApiKey&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> Revoked API Key&#39;s metadata </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<UserApiKey> revokeApiKeyWithHttpInfo(String orgId, String userId, String keyId) throws ApiException {
        okhttp3.Call localVarCall = revokeApiKeyValidateBeforeCall(orgId, userId, keyId, null);
        Type localVarReturnType = new TypeToken<UserApiKey>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Revoke the given API Key, removing its ability to access WhyLabs systems (asynchronously)
     * Revokes the given API Key
     * @param orgId  (required)
     * @param userId  (required)
     * @param keyId ID of the key to revoke  Metadata for the revoked API Key (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> Revoked API Key&#39;s metadata </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call revokeApiKeyAsync(String orgId, String userId, String keyId, final ApiCallback<UserApiKey> _callback) throws ApiException {

        okhttp3.Call localVarCall = revokeApiKeyValidateBeforeCall(orgId, userId, keyId, _callback);
        Type localVarReturnType = new TypeToken<UserApiKey>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
