/*
 * WhyLabs API client
 * WhyLabs API that enables end-to-end AI observability
 *
 * The version of the OpenAPI document: 0.1
 * Contact: support@whylabs.ai
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package ai.whylabs.service.api;

import ai.whylabs.service.invoker.ApiCallback;
import ai.whylabs.service.invoker.ApiClient;
import ai.whylabs.service.invoker.ApiException;
import ai.whylabs.service.invoker.ApiResponse;
import ai.whylabs.service.invoker.Configuration;
import ai.whylabs.service.invoker.Pair;
import ai.whylabs.service.invoker.ProgressRequestBody;
import ai.whylabs.service.invoker.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import java.io.File;
import ai.whylabs.service.model.SegmentTag;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EventsApi {
    private ApiClient localVarApiClient;

    public EventsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public EventsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    /**
     * Build call for getEventsData
     * @param orgId Your company&#39;s unique organization ID (required)
     * @param modelId The unique model ID in your company. The model is created if it doesn&#39;t exist already. (required)
     * @param startTimestamp Start time exclusive (required)
     * @param endTimestamp  (required)
     * @param segmentTags List of (key, value) pair tags for a segment. Must not contain duplicate values (optional)
     * @param version the version of the event (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A streaming JSON output in multiline JSON format </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getEventsDataCall(String orgId, String modelId, Long startTimestamp, Long endTimestamp, List<SegmentTag> segmentTags, String version, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v0/organizations/{org_id}/events/models/{model_id}/data"
            .replaceAll("\\{" + "org_id" + "\\}", localVarApiClient.escapeString(orgId.toString()))
            .replaceAll("\\{" + "model_id" + "\\}", localVarApiClient.escapeString(modelId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (segmentTags != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("multi", "segment_tags", segmentTags));
        }

        if (startTimestamp != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("start_timestamp", startTimestamp));
        }

        if (endTimestamp != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("end_timestamp", endTimestamp));
        }

        if (version != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("version", version));
        }

        final String[] localVarAccepts = {
            "application/x-json-stream"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "ApiKeyAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getEventsDataValidateBeforeCall(String orgId, String modelId, Long startTimestamp, Long endTimestamp, List<SegmentTag> segmentTags, String version, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'orgId' is set
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling getEventsData(Async)");
        }
        
        // verify the required parameter 'modelId' is set
        if (modelId == null) {
            throw new ApiException("Missing the required parameter 'modelId' when calling getEventsData(Async)");
        }
        
        // verify the required parameter 'startTimestamp' is set
        if (startTimestamp == null) {
            throw new ApiException("Missing the required parameter 'startTimestamp' when calling getEventsData(Async)");
        }
        
        // verify the required parameter 'endTimestamp' is set
        if (endTimestamp == null) {
            throw new ApiException("Missing the required parameter 'endTimestamp' when calling getEventsData(Async)");
        }
        

        okhttp3.Call localVarCall = getEventsDataCall(orgId, modelId, startTimestamp, endTimestamp, segmentTags, version, _callback);
        return localVarCall;

    }

    /**
     * Get the event data as multi-line JSON for a given time period.
     * Get the events from a given time period.
     * @param orgId Your company&#39;s unique organization ID (required)
     * @param modelId The unique model ID in your company. The model is created if it doesn&#39;t exist already. (required)
     * @param startTimestamp Start time exclusive (required)
     * @param endTimestamp  (required)
     * @param segmentTags List of (key, value) pair tags for a segment. Must not contain duplicate values (optional)
     * @param version the version of the event (optional)
     * @return File
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A streaming JSON output in multiline JSON format </td><td>  -  </td></tr>
     </table>
     */
    public File getEventsData(String orgId, String modelId, Long startTimestamp, Long endTimestamp, List<SegmentTag> segmentTags, String version) throws ApiException {
        ApiResponse<File> localVarResp = getEventsDataWithHttpInfo(orgId, modelId, startTimestamp, endTimestamp, segmentTags, version);
        return localVarResp.getData();
    }

    /**
     * Get the event data as multi-line JSON for a given time period.
     * Get the events from a given time period.
     * @param orgId Your company&#39;s unique organization ID (required)
     * @param modelId The unique model ID in your company. The model is created if it doesn&#39;t exist already. (required)
     * @param startTimestamp Start time exclusive (required)
     * @param endTimestamp  (required)
     * @param segmentTags List of (key, value) pair tags for a segment. Must not contain duplicate values (optional)
     * @param version the version of the event (optional)
     * @return ApiResponse&lt;File&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A streaming JSON output in multiline JSON format </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<File> getEventsDataWithHttpInfo(String orgId, String modelId, Long startTimestamp, Long endTimestamp, List<SegmentTag> segmentTags, String version) throws ApiException {
        okhttp3.Call localVarCall = getEventsDataValidateBeforeCall(orgId, modelId, startTimestamp, endTimestamp, segmentTags, version, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get the event data as multi-line JSON for a given time period. (asynchronously)
     * Get the events from a given time period.
     * @param orgId Your company&#39;s unique organization ID (required)
     * @param modelId The unique model ID in your company. The model is created if it doesn&#39;t exist already. (required)
     * @param startTimestamp Start time exclusive (required)
     * @param endTimestamp  (required)
     * @param segmentTags List of (key, value) pair tags for a segment. Must not contain duplicate values (optional)
     * @param version the version of the event (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> A streaming JSON output in multiline JSON format </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getEventsDataAsync(String orgId, String modelId, Long startTimestamp, Long endTimestamp, List<SegmentTag> segmentTags, String version, final ApiCallback<File> _callback) throws ApiException {

        okhttp3.Call localVarCall = getEventsDataValidateBeforeCall(orgId, modelId, startTimestamp, endTimestamp, segmentTags, version, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
