/*
 * WhyLabs API client
 * WhyLabs API that enables end-to-end AI observability
 *
 * The version of the OpenAPI document: 0.1
 * Contact: support@whylabs.ai
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package ai.whylabs.service.api;

import ai.whylabs.service.invoker.ApiCallback;
import ai.whylabs.service.invoker.ApiClient;
import ai.whylabs.service.invoker.ApiException;
import ai.whylabs.service.invoker.ApiResponse;
import ai.whylabs.service.invoker.Configuration;
import ai.whylabs.service.invoker.Pair;
import ai.whylabs.service.invoker.ProgressRequestBody;
import ai.whylabs.service.invoker.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import ai.whylabs.service.model.AsyncLogResponse;
import java.io.File;
import ai.whylabs.service.model.LogAsyncRequest;
import ai.whylabs.service.model.LogResponse;
import ai.whylabs.service.model.SegmentTag;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LogApi {
    private ApiClient localVarApiClient;

    public LogApi() {
        this(Configuration.getDefaultApiClient());
    }

    public LogApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    /**
     * Build call for log
     * @param orgId Your company&#39;s unique organization ID (required)
     * @param modelId The unique model ID in your company. (required)
     * @param datasetTimestamp The dataset timestamp associated with the entry. Not required. However, this will  override the whylogs dataset timestamp if specified (optional)
     * @param segmentTags The segment associated with the log entry. Not required if segment tags are specified in whylogs (optional)
     * @param segmentTagsJson  (optional)
     * @param file The Dataset Profile log entry (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> a LogResponse object if succeeds </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call logCall(String orgId, String modelId, Long datasetTimestamp, List<SegmentTag> segmentTags, String segmentTagsJson, File file, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v0/organizations/{org_id}/log"
            .replaceAll("\\{" + "org_id" + "\\}", localVarApiClient.escapeString(orgId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (file != null) {
            localVarFormParams.put("file", file);
        }

        if (modelId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("model_id", modelId));
        }

        if (datasetTimestamp != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("dataset_timestamp", datasetTimestamp));
        }

        if (segmentTags != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("multi", "segment_tags", segmentTags));
        }

        if (segmentTagsJson != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("segment_tags_json", segmentTagsJson));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "multipart/form-data"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "ApiKeyAuth" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call logValidateBeforeCall(String orgId, String modelId, Long datasetTimestamp, List<SegmentTag> segmentTags, String segmentTagsJson, File file, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'orgId' is set
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling log(Async)");
        }
        
        // verify the required parameter 'modelId' is set
        if (modelId == null) {
            throw new ApiException("Missing the required parameter 'modelId' when calling log(Async)");
        }
        

        okhttp3.Call localVarCall = logCall(orgId, modelId, datasetTimestamp, segmentTags, segmentTagsJson, file, _callback);
        return localVarCall;

    }

    /**
     * Log a dataset profile entry to the backend
     * This method returns a [LogResponse] object if it succeeds
     * @param orgId Your company&#39;s unique organization ID (required)
     * @param modelId The unique model ID in your company. (required)
     * @param datasetTimestamp The dataset timestamp associated with the entry. Not required. However, this will  override the whylogs dataset timestamp if specified (optional)
     * @param segmentTags The segment associated with the log entry. Not required if segment tags are specified in whylogs (optional)
     * @param segmentTagsJson  (optional)
     * @param file The Dataset Profile log entry (optional)
     * @return LogResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> a LogResponse object if succeeds </td><td>  -  </td></tr>
     </table>
     */
    public LogResponse log(String orgId, String modelId, Long datasetTimestamp, List<SegmentTag> segmentTags, String segmentTagsJson, File file) throws ApiException {
        ApiResponse<LogResponse> localVarResp = logWithHttpInfo(orgId, modelId, datasetTimestamp, segmentTags, segmentTagsJson, file);
        return localVarResp.getData();
    }

    /**
     * Log a dataset profile entry to the backend
     * This method returns a [LogResponse] object if it succeeds
     * @param orgId Your company&#39;s unique organization ID (required)
     * @param modelId The unique model ID in your company. (required)
     * @param datasetTimestamp The dataset timestamp associated with the entry. Not required. However, this will  override the whylogs dataset timestamp if specified (optional)
     * @param segmentTags The segment associated with the log entry. Not required if segment tags are specified in whylogs (optional)
     * @param segmentTagsJson  (optional)
     * @param file The Dataset Profile log entry (optional)
     * @return ApiResponse&lt;LogResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> a LogResponse object if succeeds </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<LogResponse> logWithHttpInfo(String orgId, String modelId, Long datasetTimestamp, List<SegmentTag> segmentTags, String segmentTagsJson, File file) throws ApiException {
        okhttp3.Call localVarCall = logValidateBeforeCall(orgId, modelId, datasetTimestamp, segmentTags, segmentTagsJson, file, null);
        Type localVarReturnType = new TypeToken<LogResponse>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Log a dataset profile entry to the backend (asynchronously)
     * This method returns a [LogResponse] object if it succeeds
     * @param orgId Your company&#39;s unique organization ID (required)
     * @param modelId The unique model ID in your company. (required)
     * @param datasetTimestamp The dataset timestamp associated with the entry. Not required. However, this will  override the whylogs dataset timestamp if specified (optional)
     * @param segmentTags The segment associated with the log entry. Not required if segment tags are specified in whylogs (optional)
     * @param segmentTagsJson  (optional)
     * @param file The Dataset Profile log entry (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> a LogResponse object if succeeds </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call logAsync(String orgId, String modelId, Long datasetTimestamp, List<SegmentTag> segmentTags, String segmentTagsJson, File file, final ApiCallback<LogResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = logValidateBeforeCall(orgId, modelId, datasetTimestamp, segmentTags, segmentTagsJson, file, _callback);
        Type localVarReturnType = new TypeToken<LogResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for logAsync
     * @param orgId  (required)
     * @param datasetId  (required)
     * @param logAsyncRequest  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> LogAsync default response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call logAsyncCall(String orgId, String datasetId, LogAsyncRequest logAsyncRequest, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = logAsyncRequest;

        // create path and map variables
        String localVarPath = "/v0/organizations/{org_id}/log/async/{dataset_id}"
            .replaceAll("\\{" + "org_id" + "\\}", localVarApiClient.escapeString(orgId.toString()))
            .replaceAll("\\{" + "dataset_id" + "\\}", localVarApiClient.escapeString(datasetId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "ApiKeyAuth" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call logAsyncValidateBeforeCall(String orgId, String datasetId, LogAsyncRequest logAsyncRequest, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'orgId' is set
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling logAsync(Async)");
        }
        
        // verify the required parameter 'datasetId' is set
        if (datasetId == null) {
            throw new ApiException("Missing the required parameter 'datasetId' when calling logAsync(Async)");
        }
        
        // verify the required parameter 'logAsyncRequest' is set
        if (logAsyncRequest == null) {
            throw new ApiException("Missing the required parameter 'logAsyncRequest' when calling logAsync(Async)");
        }
        

        okhttp3.Call localVarCall = logAsyncCall(orgId, datasetId, logAsyncRequest, _callback);
        return localVarCall;

    }

    /**
     * Like /log, except this api doesn&#39;t take the actual profile content. It returns an upload link that can be used to upload the profile to.
     * Like /log, except this api doesn&#39;t take the actual profile content. It returns an upload link that can be used to upload the profile to.
     * @param orgId  (required)
     * @param datasetId  (required)
     * @param logAsyncRequest  (required)
     * @return AsyncLogResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> LogAsync default response </td><td>  -  </td></tr>
     </table>
     */
    public AsyncLogResponse logAsync(String orgId, String datasetId, LogAsyncRequest logAsyncRequest) throws ApiException {
        ApiResponse<AsyncLogResponse> localVarResp = logAsyncWithHttpInfo(orgId, datasetId, logAsyncRequest);
        return localVarResp.getData();
    }

    /**
     * Like /log, except this api doesn&#39;t take the actual profile content. It returns an upload link that can be used to upload the profile to.
     * Like /log, except this api doesn&#39;t take the actual profile content. It returns an upload link that can be used to upload the profile to.
     * @param orgId  (required)
     * @param datasetId  (required)
     * @param logAsyncRequest  (required)
     * @return ApiResponse&lt;AsyncLogResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> LogAsync default response </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<AsyncLogResponse> logAsyncWithHttpInfo(String orgId, String datasetId, LogAsyncRequest logAsyncRequest) throws ApiException {
        okhttp3.Call localVarCall = logAsyncValidateBeforeCall(orgId, datasetId, logAsyncRequest, null);
        Type localVarReturnType = new TypeToken<AsyncLogResponse>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Like /log, except this api doesn&#39;t take the actual profile content. It returns an upload link that can be used to upload the profile to. (asynchronously)
     * Like /log, except this api doesn&#39;t take the actual profile content. It returns an upload link that can be used to upload the profile to.
     * @param orgId  (required)
     * @param datasetId  (required)
     * @param logAsyncRequest  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> LogAsync default response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call logAsyncAsync(String orgId, String datasetId, LogAsyncRequest logAsyncRequest, final ApiCallback<AsyncLogResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = logAsyncValidateBeforeCall(orgId, datasetId, logAsyncRequest, _callback);
        Type localVarReturnType = new TypeToken<AsyncLogResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for removeStagedLogEntry
     * @param orgId Your company&#39;s unique organization ID (required)
     * @param logEntryId The unique ID for the log entry (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> A [LogResponse] object with summary information about the log entry </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call removeStagedLogEntryCall(String orgId, String logEntryId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v0/organizations/{org_id}/log/log-entry-id/{log_entry_id}"
            .replaceAll("\\{" + "org_id" + "\\}", localVarApiClient.escapeString(orgId.toString()))
            .replaceAll("\\{" + "log_entry_id" + "\\}", localVarApiClient.escapeString(logEntryId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "ApiKeyAuth" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call removeStagedLogEntryValidateBeforeCall(String orgId, String logEntryId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'orgId' is set
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling removeStagedLogEntry(Async)");
        }
        
        // verify the required parameter 'logEntryId' is set
        if (logEntryId == null) {
            throw new ApiException("Missing the required parameter 'logEntryId' when calling removeStagedLogEntry(Async)");
        }
        

        okhttp3.Call localVarCall = removeStagedLogEntryCall(orgId, logEntryId, _callback);
        return localVarCall;

    }

    /**
     * Remove a log entry from &#39;staging&#39; - effectively remove it from being included in [CreateMergeJob] API calls
     * This method returns a [LogResponse] object if it succeeds
     * @param orgId Your company&#39;s unique organization ID (required)
     * @param logEntryId The unique ID for the log entry (required)
     * @return LogResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> A [LogResponse] object with summary information about the log entry </td><td>  -  </td></tr>
     </table>
     */
    public LogResponse removeStagedLogEntry(String orgId, String logEntryId) throws ApiException {
        ApiResponse<LogResponse> localVarResp = removeStagedLogEntryWithHttpInfo(orgId, logEntryId);
        return localVarResp.getData();
    }

    /**
     * Remove a log entry from &#39;staging&#39; - effectively remove it from being included in [CreateMergeJob] API calls
     * This method returns a [LogResponse] object if it succeeds
     * @param orgId Your company&#39;s unique organization ID (required)
     * @param logEntryId The unique ID for the log entry (required)
     * @return ApiResponse&lt;LogResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> A [LogResponse] object with summary information about the log entry </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<LogResponse> removeStagedLogEntryWithHttpInfo(String orgId, String logEntryId) throws ApiException {
        okhttp3.Call localVarCall = removeStagedLogEntryValidateBeforeCall(orgId, logEntryId, null);
        Type localVarReturnType = new TypeToken<LogResponse>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Remove a log entry from &#39;staging&#39; - effectively remove it from being included in [CreateMergeJob] API calls (asynchronously)
     * This method returns a [LogResponse] object if it succeeds
     * @param orgId Your company&#39;s unique organization ID (required)
     * @param logEntryId The unique ID for the log entry (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> A [LogResponse] object with summary information about the log entry </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call removeStagedLogEntryAsync(String orgId, String logEntryId, final ApiCallback<LogResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = removeStagedLogEntryValidateBeforeCall(orgId, logEntryId, _callback);
        Type localVarReturnType = new TypeToken<LogResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
