/*
 * WhyLabs API client
 * WhyLabs API that enables end-to-end AI observability
 *
 * The version of the OpenAPI document: 0.1
 * Contact: support@whylabs.ai
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package ai.whylabs.service.api;

import ai.whylabs.service.invoker.ApiCallback;
import ai.whylabs.service.invoker.ApiClient;
import ai.whylabs.service.invoker.ApiException;
import ai.whylabs.service.invoker.ApiResponse;
import ai.whylabs.service.invoker.Configuration;
import ai.whylabs.service.invoker.Pair;
import ai.whylabs.service.invoker.ProgressRequestBody;
import ai.whylabs.service.invoker.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import ai.whylabs.service.model.ListModelsResponse;
import ai.whylabs.service.model.ListSegmentsResponse;
import ai.whylabs.service.model.ModelMetadata;
import ai.whylabs.service.model.ModelType;
import ai.whylabs.service.model.SegmentMetadata;
import ai.whylabs.service.model.SegmentTag;
import ai.whylabs.service.model.TimePeriod;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ModelsApi {
    private ApiClient localVarApiClient;

    public ModelsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ModelsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    /**
     * Build call for createModel
     * @param orgId The organization ID (required)
     * @param modelName The name of a model (required)
     * @param timePeriod The [TimePeriod] for data aggregation/alerting for a model (required)
     * @param modelType The [ModelType] of the dataset (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> The [ModelMetadata] if operation succeeds </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createModelCall(String orgId, String modelName, TimePeriod timePeriod, ModelType modelType, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v0/organizations/{org_id}/models"
            .replaceAll("\\{" + "org_id" + "\\}", localVarApiClient.escapeString(orgId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (modelName != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("model_name", modelName));
        }

        if (timePeriod != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("time_period", timePeriod));
        }

        if (modelType != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("model_type", modelType));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "ApiKeyAuth" };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createModelValidateBeforeCall(String orgId, String modelName, TimePeriod timePeriod, ModelType modelType, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'orgId' is set
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling createModel(Async)");
        }
        
        // verify the required parameter 'modelName' is set
        if (modelName == null) {
            throw new ApiException("Missing the required parameter 'modelName' when calling createModel(Async)");
        }
        
        // verify the required parameter 'timePeriod' is set
        if (timePeriod == null) {
            throw new ApiException("Missing the required parameter 'timePeriod' when calling createModel(Async)");
        }
        

        okhttp3.Call localVarCall = createModelCall(orgId, modelName, timePeriod, modelType, _callback);
        return localVarCall;

    }

    /**
     * Create a model with a given name and a time period
     * Create a model
     * @param orgId The organization ID (required)
     * @param modelName The name of a model (required)
     * @param timePeriod The [TimePeriod] for data aggregation/alerting for a model (required)
     * @param modelType The [ModelType] of the dataset (optional)
     * @return ModelMetadata
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> The [ModelMetadata] if operation succeeds </td><td>  -  </td></tr>
     </table>
     */
    public ModelMetadata createModel(String orgId, String modelName, TimePeriod timePeriod, ModelType modelType) throws ApiException {
        ApiResponse<ModelMetadata> localVarResp = createModelWithHttpInfo(orgId, modelName, timePeriod, modelType);
        return localVarResp.getData();
    }

    /**
     * Create a model with a given name and a time period
     * Create a model
     * @param orgId The organization ID (required)
     * @param modelName The name of a model (required)
     * @param timePeriod The [TimePeriod] for data aggregation/alerting for a model (required)
     * @param modelType The [ModelType] of the dataset (optional)
     * @return ApiResponse&lt;ModelMetadata&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> The [ModelMetadata] if operation succeeds </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<ModelMetadata> createModelWithHttpInfo(String orgId, String modelName, TimePeriod timePeriod, ModelType modelType) throws ApiException {
        okhttp3.Call localVarCall = createModelValidateBeforeCall(orgId, modelName, timePeriod, modelType, null);
        Type localVarReturnType = new TypeToken<ModelMetadata>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Create a model with a given name and a time period (asynchronously)
     * Create a model
     * @param orgId The organization ID (required)
     * @param modelName The name of a model (required)
     * @param timePeriod The [TimePeriod] for data aggregation/alerting for a model (required)
     * @param modelType The [ModelType] of the dataset (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> The [ModelMetadata] if operation succeeds </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createModelAsync(String orgId, String modelName, TimePeriod timePeriod, ModelType modelType, final ApiCallback<ModelMetadata> _callback) throws ApiException {

        okhttp3.Call localVarCall = createModelValidateBeforeCall(orgId, modelName, timePeriod, modelType, _callback);
        Type localVarReturnType = new TypeToken<ModelMetadata>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for deactivateModel
     * @param orgId The organization ID (required)
     * @param modelId The model ID (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> The [ModelMetadata] if operation succeeds </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deactivateModelCall(String orgId, String modelId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v0/organizations/{org_id}/models/{model_id}"
            .replaceAll("\\{" + "org_id" + "\\}", localVarApiClient.escapeString(orgId.toString()))
            .replaceAll("\\{" + "model_id" + "\\}", localVarApiClient.escapeString(modelId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "ApiKeyAuth" };
        return localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deactivateModelValidateBeforeCall(String orgId, String modelId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'orgId' is set
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling deactivateModel(Async)");
        }
        
        // verify the required parameter 'modelId' is set
        if (modelId == null) {
            throw new ApiException("Missing the required parameter 'modelId' when calling deactivateModel(Async)");
        }
        

        okhttp3.Call localVarCall = deactivateModelCall(orgId, modelId, _callback);
        return localVarCall;

    }

    /**
     * Mark a model as inactive
     * Mark a model as inactive
     * @param orgId The organization ID (required)
     * @param modelId The model ID (required)
     * @return ModelMetadata
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> The [ModelMetadata] if operation succeeds </td><td>  -  </td></tr>
     </table>
     */
    public ModelMetadata deactivateModel(String orgId, String modelId) throws ApiException {
        ApiResponse<ModelMetadata> localVarResp = deactivateModelWithHttpInfo(orgId, modelId);
        return localVarResp.getData();
    }

    /**
     * Mark a model as inactive
     * Mark a model as inactive
     * @param orgId The organization ID (required)
     * @param modelId The model ID (required)
     * @return ApiResponse&lt;ModelMetadata&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> The [ModelMetadata] if operation succeeds </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<ModelMetadata> deactivateModelWithHttpInfo(String orgId, String modelId) throws ApiException {
        okhttp3.Call localVarCall = deactivateModelValidateBeforeCall(orgId, modelId, null);
        Type localVarReturnType = new TypeToken<ModelMetadata>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Mark a model as inactive (asynchronously)
     * Mark a model as inactive
     * @param orgId The organization ID (required)
     * @param modelId The model ID (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> The [ModelMetadata] if operation succeeds </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deactivateModelAsync(String orgId, String modelId, final ApiCallback<ModelMetadata> _callback) throws ApiException {

        okhttp3.Call localVarCall = deactivateModelValidateBeforeCall(orgId, modelId, _callback);
        Type localVarReturnType = new TypeToken<ModelMetadata>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getModel
     * @param orgId The name of an organization (required)
     * @param modelId The ID of a model (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> A [ModelMetadata] object if operation succeeds </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getModelCall(String orgId, String modelId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v0/organizations/{org_id}/models/{model_id}"
            .replaceAll("\\{" + "org_id" + "\\}", localVarApiClient.escapeString(orgId.toString()))
            .replaceAll("\\{" + "model_id" + "\\}", localVarApiClient.escapeString(modelId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "ApiKeyAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getModelValidateBeforeCall(String orgId, String modelId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'orgId' is set
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling getModel(Async)");
        }
        
        // verify the required parameter 'modelId' is set
        if (modelId == null) {
            throw new ApiException("Missing the required parameter 'modelId' when calling getModel(Async)");
        }
        

        okhttp3.Call localVarCall = getModelCall(orgId, modelId, _callback);
        return localVarCall;

    }

    /**
     * Get a model metadata
     * Returns various metadata about a model
     * @param orgId The name of an organization (required)
     * @param modelId The ID of a model (required)
     * @return ModelMetadata
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> A [ModelMetadata] object if operation succeeds </td><td>  -  </td></tr>
     </table>
     */
    public ModelMetadata getModel(String orgId, String modelId) throws ApiException {
        ApiResponse<ModelMetadata> localVarResp = getModelWithHttpInfo(orgId, modelId);
        return localVarResp.getData();
    }

    /**
     * Get a model metadata
     * Returns various metadata about a model
     * @param orgId The name of an organization (required)
     * @param modelId The ID of a model (required)
     * @return ApiResponse&lt;ModelMetadata&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> A [ModelMetadata] object if operation succeeds </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<ModelMetadata> getModelWithHttpInfo(String orgId, String modelId) throws ApiException {
        okhttp3.Call localVarCall = getModelValidateBeforeCall(orgId, modelId, null);
        Type localVarReturnType = new TypeToken<ModelMetadata>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get a model metadata (asynchronously)
     * Returns various metadata about a model
     * @param orgId The name of an organization (required)
     * @param modelId The ID of a model (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> A [ModelMetadata] object if operation succeeds </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getModelAsync(String orgId, String modelId, final ApiCallback<ModelMetadata> _callback) throws ApiException {

        okhttp3.Call localVarCall = getModelValidateBeforeCall(orgId, modelId, _callback);
        Type localVarReturnType = new TypeToken<ModelMetadata>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listModels
     * @param orgId Your company&#39;s unique organization ID (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> A list of model summary items </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listModelsCall(String orgId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v0/organizations/{org_id}/models"
            .replaceAll("\\{" + "org_id" + "\\}", localVarApiClient.escapeString(orgId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "ApiKeyAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listModelsValidateBeforeCall(String orgId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'orgId' is set
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling listModels(Async)");
        }
        

        okhttp3.Call localVarCall = listModelsCall(orgId, _callback);
        return localVarCall;

    }

    /**
     * Get a list of all of the model ids for an organization.
     * Get a list of all of the model ids for an organization.
     * @param orgId Your company&#39;s unique organization ID (required)
     * @return ListModelsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> A list of model summary items </td><td>  -  </td></tr>
     </table>
     */
    public ListModelsResponse listModels(String orgId) throws ApiException {
        ApiResponse<ListModelsResponse> localVarResp = listModelsWithHttpInfo(orgId);
        return localVarResp.getData();
    }

    /**
     * Get a list of all of the model ids for an organization.
     * Get a list of all of the model ids for an organization.
     * @param orgId Your company&#39;s unique organization ID (required)
     * @return ApiResponse&lt;ListModelsResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> A list of model summary items </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<ListModelsResponse> listModelsWithHttpInfo(String orgId) throws ApiException {
        okhttp3.Call localVarCall = listModelsValidateBeforeCall(orgId, null);
        Type localVarReturnType = new TypeToken<ListModelsResponse>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get a list of all of the model ids for an organization. (asynchronously)
     * Get a list of all of the model ids for an organization.
     * @param orgId Your company&#39;s unique organization ID (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> A list of model summary items </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listModelsAsync(String orgId, final ApiCallback<ListModelsResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = listModelsValidateBeforeCall(orgId, _callback);
        Type localVarReturnType = new TypeToken<ListModelsResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for listSegments
     * @param orgId The name of an organization (required)
     * @param modelId The ID of a model (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> A [ListSegmentsResponse] object if operation succeeds </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listSegmentsCall(String orgId, String modelId, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v0/organizations/{org_id}/models/{model_id}/segments"
            .replaceAll("\\{" + "org_id" + "\\}", localVarApiClient.escapeString(orgId.toString()))
            .replaceAll("\\{" + "model_id" + "\\}", localVarApiClient.escapeString(modelId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "ApiKeyAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listSegmentsValidateBeforeCall(String orgId, String modelId, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'orgId' is set
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling listSegments(Async)");
        }
        
        // verify the required parameter 'modelId' is set
        if (modelId == null) {
            throw new ApiException("Missing the required parameter 'modelId' when calling listSegments(Async)");
        }
        

        okhttp3.Call localVarCall = listSegmentsCall(orgId, modelId, _callback);
        return localVarCall;

    }

    /**
     * Get a model metadata
     * Returns the list of Segments for a given model
     * @param orgId The name of an organization (required)
     * @param modelId The ID of a model (required)
     * @return ListSegmentsResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> A [ListSegmentsResponse] object if operation succeeds </td><td>  -  </td></tr>
     </table>
     */
    public ListSegmentsResponse listSegments(String orgId, String modelId) throws ApiException {
        ApiResponse<ListSegmentsResponse> localVarResp = listSegmentsWithHttpInfo(orgId, modelId);
        return localVarResp.getData();
    }

    /**
     * Get a model metadata
     * Returns the list of Segments for a given model
     * @param orgId The name of an organization (required)
     * @param modelId The ID of a model (required)
     * @return ApiResponse&lt;ListSegmentsResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> A [ListSegmentsResponse] object if operation succeeds </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<ListSegmentsResponse> listSegmentsWithHttpInfo(String orgId, String modelId) throws ApiException {
        okhttp3.Call localVarCall = listSegmentsValidateBeforeCall(orgId, modelId, null);
        Type localVarReturnType = new TypeToken<ListSegmentsResponse>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get a model metadata (asynchronously)
     * Returns the list of Segments for a given model
     * @param orgId The name of an organization (required)
     * @param modelId The ID of a model (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> A [ListSegmentsResponse] object if operation succeeds </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listSegmentsAsync(String orgId, String modelId, final ApiCallback<ListSegmentsResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = listSegmentsValidateBeforeCall(orgId, modelId, _callback);
        Type localVarReturnType = new TypeToken<ListSegmentsResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for putSegments
     * @param orgId The name of an organization (required)
     * @param modelId The ID of a model (required)
     * @param segmentTag List of segment tags to create the segment for (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> A [SegmentMetadata] object if operation succeeds </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call putSegmentsCall(String orgId, String modelId, List<SegmentTag> segmentTag, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = segmentTag;

        // create path and map variables
        String localVarPath = "/v0/organizations/{org_id}/models/{model_id}/segments"
            .replaceAll("\\{" + "org_id" + "\\}", localVarApiClient.escapeString(orgId.toString()))
            .replaceAll("\\{" + "model_id" + "\\}", localVarApiClient.escapeString(modelId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "ApiKeyAuth" };
        return localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call putSegmentsValidateBeforeCall(String orgId, String modelId, List<SegmentTag> segmentTag, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'orgId' is set
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling putSegments(Async)");
        }
        
        // verify the required parameter 'modelId' is set
        if (modelId == null) {
            throw new ApiException("Missing the required parameter 'modelId' when calling putSegments(Async)");
        }
        
        // verify the required parameter 'segmentTag' is set
        if (segmentTag == null) {
            throw new ApiException("Missing the required parameter 'segmentTag' when calling putSegments(Async)");
        }
        

        okhttp3.Call localVarCall = putSegmentsCall(orgId, modelId, segmentTag, _callback);
        return localVarCall;

    }

    /**
     * Add a segment to the dataset
     * Return 200 if succeeds
     * @param orgId The name of an organization (required)
     * @param modelId The ID of a model (required)
     * @param segmentTag List of segment tags to create the segment for (required)
     * @return SegmentMetadata
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> A [SegmentMetadata] object if operation succeeds </td><td>  -  </td></tr>
     </table>
     */
    public SegmentMetadata putSegments(String orgId, String modelId, List<SegmentTag> segmentTag) throws ApiException {
        ApiResponse<SegmentMetadata> localVarResp = putSegmentsWithHttpInfo(orgId, modelId, segmentTag);
        return localVarResp.getData();
    }

    /**
     * Add a segment to the dataset
     * Return 200 if succeeds
     * @param orgId The name of an organization (required)
     * @param modelId The ID of a model (required)
     * @param segmentTag List of segment tags to create the segment for (required)
     * @return ApiResponse&lt;SegmentMetadata&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> A [SegmentMetadata] object if operation succeeds </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<SegmentMetadata> putSegmentsWithHttpInfo(String orgId, String modelId, List<SegmentTag> segmentTag) throws ApiException {
        okhttp3.Call localVarCall = putSegmentsValidateBeforeCall(orgId, modelId, segmentTag, null);
        Type localVarReturnType = new TypeToken<SegmentMetadata>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Add a segment to the dataset (asynchronously)
     * Return 200 if succeeds
     * @param orgId The name of an organization (required)
     * @param modelId The ID of a model (required)
     * @param segmentTag List of segment tags to create the segment for (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> A [SegmentMetadata] object if operation succeeds </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call putSegmentsAsync(String orgId, String modelId, List<SegmentTag> segmentTag, final ApiCallback<SegmentMetadata> _callback) throws ApiException {

        okhttp3.Call localVarCall = putSegmentsValidateBeforeCall(orgId, modelId, segmentTag, _callback);
        Type localVarReturnType = new TypeToken<SegmentMetadata>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for updateModel
     * @param orgId The organization ID (required)
     * @param modelId The model ID (required)
     * @param modelName The name of a model (required)
     * @param timePeriod The [TimePeriod] for data aggregation/alerting for a model (required)
     * @param modelType The [ModelType] of the dataset (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> The [ModelMetadata] if operation succeeds </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateModelCall(String orgId, String modelId, String modelName, TimePeriod timePeriod, ModelType modelType, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v0/organizations/{org_id}/models/{model_id}"
            .replaceAll("\\{" + "org_id" + "\\}", localVarApiClient.escapeString(orgId.toString()))
            .replaceAll("\\{" + "model_id" + "\\}", localVarApiClient.escapeString(modelId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (modelName != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("model_name", modelName));
        }

        if (timePeriod != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("time_period", timePeriod));
        }

        if (modelType != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("model_type", modelType));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "ApiKeyAuth" };
        return localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call updateModelValidateBeforeCall(String orgId, String modelId, String modelName, TimePeriod timePeriod, ModelType modelType, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'orgId' is set
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling updateModel(Async)");
        }
        
        // verify the required parameter 'modelId' is set
        if (modelId == null) {
            throw new ApiException("Missing the required parameter 'modelId' when calling updateModel(Async)");
        }
        
        // verify the required parameter 'modelName' is set
        if (modelName == null) {
            throw new ApiException("Missing the required parameter 'modelName' when calling updateModel(Async)");
        }
        
        // verify the required parameter 'timePeriod' is set
        if (timePeriod == null) {
            throw new ApiException("Missing the required parameter 'timePeriod' when calling updateModel(Async)");
        }
        

        okhttp3.Call localVarCall = updateModelCall(orgId, modelId, modelName, timePeriod, modelType, _callback);
        return localVarCall;

    }

    /**
     * Update a model&#39;s metadata
     * Update a model&#39;s metadata
     * @param orgId The organization ID (required)
     * @param modelId The model ID (required)
     * @param modelName The name of a model (required)
     * @param timePeriod The [TimePeriod] for data aggregation/alerting for a model (required)
     * @param modelType The [ModelType] of the dataset (optional)
     * @return ModelMetadata
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> The [ModelMetadata] if operation succeeds </td><td>  -  </td></tr>
     </table>
     */
    public ModelMetadata updateModel(String orgId, String modelId, String modelName, TimePeriod timePeriod, ModelType modelType) throws ApiException {
        ApiResponse<ModelMetadata> localVarResp = updateModelWithHttpInfo(orgId, modelId, modelName, timePeriod, modelType);
        return localVarResp.getData();
    }

    /**
     * Update a model&#39;s metadata
     * Update a model&#39;s metadata
     * @param orgId The organization ID (required)
     * @param modelId The model ID (required)
     * @param modelName The name of a model (required)
     * @param timePeriod The [TimePeriod] for data aggregation/alerting for a model (required)
     * @param modelType The [ModelType] of the dataset (optional)
     * @return ApiResponse&lt;ModelMetadata&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> The [ModelMetadata] if operation succeeds </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<ModelMetadata> updateModelWithHttpInfo(String orgId, String modelId, String modelName, TimePeriod timePeriod, ModelType modelType) throws ApiException {
        okhttp3.Call localVarCall = updateModelValidateBeforeCall(orgId, modelId, modelName, timePeriod, modelType, null);
        Type localVarReturnType = new TypeToken<ModelMetadata>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Update a model&#39;s metadata (asynchronously)
     * Update a model&#39;s metadata
     * @param orgId The organization ID (required)
     * @param modelId The model ID (required)
     * @param modelName The name of a model (required)
     * @param timePeriod The [TimePeriod] for data aggregation/alerting for a model (required)
     * @param modelType The [ModelType] of the dataset (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> The [ModelMetadata] if operation succeeds </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateModelAsync(String orgId, String modelId, String modelName, TimePeriod timePeriod, ModelType modelType, final ApiCallback<ModelMetadata> _callback) throws ApiException {

        okhttp3.Call localVarCall = updateModelValidateBeforeCall(orgId, modelId, modelName, timePeriod, modelType, _callback);
        Type localVarReturnType = new TypeToken<ModelMetadata>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
