/*
 * WhyLabs API client
 * WhyLabs API that enables end-to-end AI observability
 *
 * The version of the OpenAPI document: 0.1
 * Contact: support@whylabs.ai
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package ai.whylabs.service.api;

import ai.whylabs.service.invoker.ApiCallback;
import ai.whylabs.service.invoker.ApiClient;
import ai.whylabs.service.invoker.ApiException;
import ai.whylabs.service.invoker.ApiResponse;
import ai.whylabs.service.invoker.Configuration;
import ai.whylabs.service.invoker.Pair;
import ai.whylabs.service.invoker.ProgressRequestBody;
import ai.whylabs.service.invoker.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import ai.whylabs.service.model.CloseSessionResponse;
import ai.whylabs.service.model.CreateSessionResponse;
import ai.whylabs.service.model.CreateSessionUploadResponse;
import ai.whylabs.service.model.GetSessionResponse;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SessionsApi {
    private ApiClient localVarApiClient;

    public SessionsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SessionsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    /**
     * Build call for closeSession
     * @param sessionToken  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> CloseSession default response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call closeSessionCall(String sessionToken, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v0/sessions/{session_token}/close"
            .replaceAll("\\{" + "session_token" + "\\}", localVarApiClient.escapeString(sessionToken.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call closeSessionValidateBeforeCall(String sessionToken, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'sessionToken' is set
        if (sessionToken == null) {
            throw new ApiException("Missing the required parameter 'sessionToken' when calling closeSession(Async)");
        }
        

        okhttp3.Call localVarCall = closeSessionCall(sessionToken, _callback);
        return localVarCall;

    }

    /**
     * naddeo Close a session, triggering its display in whylabs and making it no longer accept any additional data.
     * naddeo Close a session, triggering its display in whylabs and making it no longer accept any additional data.
     * @param sessionToken  (required)
     * @return CloseSessionResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> CloseSession default response </td><td>  -  </td></tr>
     </table>
     */
    public CloseSessionResponse closeSession(String sessionToken) throws ApiException {
        ApiResponse<CloseSessionResponse> localVarResp = closeSessionWithHttpInfo(sessionToken);
        return localVarResp.getData();
    }

    /**
     * naddeo Close a session, triggering its display in whylabs and making it no longer accept any additional data.
     * naddeo Close a session, triggering its display in whylabs and making it no longer accept any additional data.
     * @param sessionToken  (required)
     * @return ApiResponse&lt;CloseSessionResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> CloseSession default response </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CloseSessionResponse> closeSessionWithHttpInfo(String sessionToken) throws ApiException {
        okhttp3.Call localVarCall = closeSessionValidateBeforeCall(sessionToken, null);
        Type localVarReturnType = new TypeToken<CloseSessionResponse>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * naddeo Close a session, triggering its display in whylabs and making it no longer accept any additional data. (asynchronously)
     * naddeo Close a session, triggering its display in whylabs and making it no longer accept any additional data.
     * @param sessionToken  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> CloseSession default response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call closeSessionAsync(String sessionToken, final ApiCallback<CloseSessionResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = closeSessionValidateBeforeCall(sessionToken, _callback);
        Type localVarReturnType = new TypeToken<CloseSessionResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for createDatasetProfileUpload
     * @param sessionToken  (required)
     * @param datasetTimestamp  (optional)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> A url that a dataset profile can be uploaded to. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createDatasetProfileUploadCall(String sessionToken, Long datasetTimestamp, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v0/sessions/{session_token}/upload"
            .replaceAll("\\{" + "session_token" + "\\}", localVarApiClient.escapeString(sessionToken.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (datasetTimestamp != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("dataset_timestamp", datasetTimestamp));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createDatasetProfileUploadValidateBeforeCall(String sessionToken, Long datasetTimestamp, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'sessionToken' is set
        if (sessionToken == null) {
            throw new ApiException("Missing the required parameter 'sessionToken' when calling createDatasetProfileUpload(Async)");
        }
        

        okhttp3.Call localVarCall = createDatasetProfileUploadCall(sessionToken, datasetTimestamp, _callback);
        return localVarCall;

    }

    /**
     * Create an upload for a given session.
     * Create an upload for a given session.
     * @param sessionToken  (required)
     * @param datasetTimestamp  (optional)
     * @return CreateSessionUploadResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> A url that a dataset profile can be uploaded to. </td><td>  -  </td></tr>
     </table>
     */
    public CreateSessionUploadResponse createDatasetProfileUpload(String sessionToken, Long datasetTimestamp) throws ApiException {
        ApiResponse<CreateSessionUploadResponse> localVarResp = createDatasetProfileUploadWithHttpInfo(sessionToken, datasetTimestamp);
        return localVarResp.getData();
    }

    /**
     * Create an upload for a given session.
     * Create an upload for a given session.
     * @param sessionToken  (required)
     * @param datasetTimestamp  (optional)
     * @return ApiResponse&lt;CreateSessionUploadResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> A url that a dataset profile can be uploaded to. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CreateSessionUploadResponse> createDatasetProfileUploadWithHttpInfo(String sessionToken, Long datasetTimestamp) throws ApiException {
        okhttp3.Call localVarCall = createDatasetProfileUploadValidateBeforeCall(sessionToken, datasetTimestamp, null);
        Type localVarReturnType = new TypeToken<CreateSessionUploadResponse>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Create an upload for a given session. (asynchronously)
     * Create an upload for a given session.
     * @param sessionToken  (required)
     * @param datasetTimestamp  (optional)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> A url that a dataset profile can be uploaded to. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createDatasetProfileUploadAsync(String sessionToken, Long datasetTimestamp, final ApiCallback<CreateSessionUploadResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = createDatasetProfileUploadValidateBeforeCall(sessionToken, datasetTimestamp, _callback);
        Type localVarReturnType = new TypeToken<CreateSessionUploadResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for createSession
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> A new session id that can be used to upload dataset profiles. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createSessionCall(final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v0/sessions";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createSessionValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = createSessionCall(_callback);
        return localVarCall;

    }

    /**
     * Create a new session that can be used to upload dataset profiles from whylogs for display in whylabs.
     * Create a new session that can be used to upload dataset profiles from whylogs for display in whylabs.
     * @return CreateSessionResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> A new session id that can be used to upload dataset profiles. </td><td>  -  </td></tr>
     </table>
     */
    public CreateSessionResponse createSession() throws ApiException {
        ApiResponse<CreateSessionResponse> localVarResp = createSessionWithHttpInfo();
        return localVarResp.getData();
    }

    /**
     * Create a new session that can be used to upload dataset profiles from whylogs for display in whylabs.
     * Create a new session that can be used to upload dataset profiles from whylogs for display in whylabs.
     * @return ApiResponse&lt;CreateSessionResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> A new session id that can be used to upload dataset profiles. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CreateSessionResponse> createSessionWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = createSessionValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<CreateSessionResponse>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Create a new session that can be used to upload dataset profiles from whylogs for display in whylabs. (asynchronously)
     * Create a new session that can be used to upload dataset profiles from whylogs for display in whylabs.
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> A new session id that can be used to upload dataset profiles. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createSessionAsync(final ApiCallback<CreateSessionResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = createSessionValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<CreateSessionResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for getSession
     * @param sessionToken  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> GetSession default response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getSessionCall(String sessionToken, final ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/v0/sessions/{session_token}"
            .replaceAll("\\{" + "session_token" + "\\}", localVarApiClient.escapeString(sessionToken.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        String[] localVarAuthNames = new String[] { "ApiKeyAuth" };
        return localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call getSessionValidateBeforeCall(String sessionToken, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'sessionToken' is set
        if (sessionToken == null) {
            throw new ApiException("Missing the required parameter 'sessionToken' when calling getSession(Async)");
        }
        

        okhttp3.Call localVarCall = getSessionCall(sessionToken, _callback);
        return localVarCall;

    }

    /**
     * Get information about a session.
     * Get information about a session.
     * @param sessionToken  (required)
     * @return GetSessionResponse
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> GetSession default response </td><td>  -  </td></tr>
     </table>
     */
    public GetSessionResponse getSession(String sessionToken) throws ApiException {
        ApiResponse<GetSessionResponse> localVarResp = getSessionWithHttpInfo(sessionToken);
        return localVarResp.getData();
    }

    /**
     * Get information about a session.
     * Get information about a session.
     * @param sessionToken  (required)
     * @return ApiResponse&lt;GetSessionResponse&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> GetSession default response </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<GetSessionResponse> getSessionWithHttpInfo(String sessionToken) throws ApiException {
        okhttp3.Call localVarCall = getSessionValidateBeforeCall(sessionToken, null);
        Type localVarReturnType = new TypeToken<GetSessionResponse>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Get information about a session. (asynchronously)
     * Get information about a session.
     * @param sessionToken  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 0 </td><td> GetSession default response </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call getSessionAsync(String sessionToken, final ApiCallback<GetSessionResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = getSessionValidateBeforeCall(sessionToken, _callback);
        Type localVarReturnType = new TypeToken<GetSessionResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
