/*
 * WhyLabs API client
 * WhyLabs API that enables end-to-end AI observability
 *
 * The version of the OpenAPI document: 0.1
 * Contact: support@whylabs.ai
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package ai.whylabs.service.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

/**
 * Response for getting sessions.
 */
@ApiModel(description = "Response for getting sessions.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2021-08-02T10:53:21.804872-07:00[America/Los_Angeles]")
public class SessionMetadata {
  public static final String SERIALIZED_NAME_SESSION_ID = "sessionId";
  @SerializedName(SERIALIZED_NAME_SESSION_ID)
  private String sessionId;

  public static final String SERIALIZED_NAME_ORG_ID = "orgId";
  @SerializedName(SERIALIZED_NAME_ORG_ID)
  private String orgId;

  public static final String SERIALIZED_NAME_MODEL_ID = "modelId";
  @SerializedName(SERIALIZED_NAME_MODEL_ID)
  private String modelId;

  public static final String SERIALIZED_NAME_CLOSED = "closed";
  @SerializedName(SERIALIZED_NAME_CLOSED)
  private Boolean closed;

  public static final String SERIALIZED_NAME_USER_ID = "userId";
  @SerializedName(SERIALIZED_NAME_USER_ID)
  private String userId;


  public SessionMetadata sessionId(String sessionId) {
    
    this.sessionId = sessionId;
    return this;
  }

   /**
   * The id of the session
   * @return sessionId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The id of the session")

  public String getSessionId() {
    return sessionId;
  }


  public void setSessionId(String sessionId) {
    this.sessionId = sessionId;
  }


  public SessionMetadata orgId(String orgId) {
    
    this.orgId = orgId;
    return this;
  }

   /**
   * The org id of the session
   * @return orgId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The org id of the session")

  public String getOrgId() {
    return orgId;
  }


  public void setOrgId(String orgId) {
    this.orgId = orgId;
  }


  public SessionMetadata modelId(String modelId) {
    
    this.modelId = modelId;
    return this;
  }

   /**
   * The model id of the session. There should only be a single model.
   * @return modelId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The model id of the session. There should only be a single model.")

  public String getModelId() {
    return modelId;
  }


  public void setModelId(String modelId) {
    this.modelId = modelId;
  }


  public SessionMetadata closed(Boolean closed) {
    
    this.closed = closed;
    return this;
  }

   /**
   * Whether or not the session is open for uploading dataset profiles to.
   * @return closed
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Whether or not the session is open for uploading dataset profiles to.")

  public Boolean getClosed() {
    return closed;
  }


  public void setClosed(Boolean closed) {
    this.closed = closed;
  }


  public SessionMetadata userId(String userId) {
    
    this.userId = userId;
    return this;
  }

   /**
   * The generated user id for the session.
   * @return userId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The generated user id for the session.")

  public String getUserId() {
    return userId;
  }


  public void setUserId(String userId) {
    this.userId = userId;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SessionMetadata sessionMetadata = (SessionMetadata) o;
    return Objects.equals(this.sessionId, sessionMetadata.sessionId) &&
        Objects.equals(this.orgId, sessionMetadata.orgId) &&
        Objects.equals(this.modelId, sessionMetadata.modelId) &&
        Objects.equals(this.closed, sessionMetadata.closed) &&
        Objects.equals(this.userId, sessionMetadata.userId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(sessionId, orgId, modelId, closed, userId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SessionMetadata {\n");
    sb.append("    sessionId: ").append(toIndentedString(sessionId)).append("\n");
    sb.append("    orgId: ").append(toIndentedString(orgId)).append("\n");
    sb.append("    modelId: ").append(toIndentedString(modelId)).append("\n");
    sb.append("    closed: ").append(toIndentedString(closed)).append("\n");
    sb.append("    userId: ").append(toIndentedString(userId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

