/*
 * WhyLabs API client
 * WhyLabs API that enables end-to-end AI observability
 *
 * The version of the OpenAPI document: 0.1
 * Contact: support@whylabs.ai
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package ai.whylabs.service.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * Response when creating an API key successfully
 */
@ApiModel(description = "Response when creating an API key successfully")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2021-08-02T10:53:21.804872-07:00[America/Los_Angeles]")
public class UserApiKey {
  public static final String SERIALIZED_NAME_KEY = "key";
  @SerializedName(SERIALIZED_NAME_KEY)
  private String key;

  public static final String SERIALIZED_NAME_KEY_ID = "keyId";
  @SerializedName(SERIALIZED_NAME_KEY_ID)
  private String keyId;

  public static final String SERIALIZED_NAME_ORG_ID = "orgId";
  @SerializedName(SERIALIZED_NAME_ORG_ID)
  private String orgId;

  public static final String SERIALIZED_NAME_USER_ID = "userId";
  @SerializedName(SERIALIZED_NAME_USER_ID)
  private String userId;

  public static final String SERIALIZED_NAME_CREATION_TIME = "creationTime";
  @SerializedName(SERIALIZED_NAME_CREATION_TIME)
  private String creationTime;

  public static final String SERIALIZED_NAME_EXPIRATION_TIME = "expirationTime";
  @SerializedName(SERIALIZED_NAME_EXPIRATION_TIME)
  private String expirationTime;

  public static final String SERIALIZED_NAME_SCOPES = "scopes";
  @SerializedName(SERIALIZED_NAME_SCOPES)
  private List<String> scopes = null;

  public static final String SERIALIZED_NAME_ALIAS = "alias";
  @SerializedName(SERIALIZED_NAME_ALIAS)
  private String alias;

  public static final String SERIALIZED_NAME_REVOKED = "revoked";
  @SerializedName(SERIALIZED_NAME_REVOKED)
  private Boolean revoked;


  public UserApiKey key(String key) {
    
    this.key = key;
    return this;
  }

   /**
   * The full value of the key. This is not persisted in the system
   * @return key
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The full value of the key. This is not persisted in the system")

  public String getKey() {
    return key;
  }


  public void setKey(String key) {
    this.key = key;
  }


  public UserApiKey keyId(String keyId) {
    
    this.keyId = keyId;
    return this;
  }

   /**
   * The key id. Can be used to identify keys for a given user
   * @return keyId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The key id. Can be used to identify keys for a given user")

  public String getKeyId() {
    return keyId;
  }


  public void setKeyId(String keyId) {
    this.keyId = keyId;
  }


  public UserApiKey orgId(String orgId) {
    
    this.orgId = orgId;
    return this;
  }

   /**
   * The organization that the key belongs to
   * @return orgId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The organization that the key belongs to")

  public String getOrgId() {
    return orgId;
  }


  public void setOrgId(String orgId) {
    this.orgId = orgId;
  }


  public UserApiKey userId(String userId) {
    
    this.userId = userId;
    return this;
  }

   /**
   * The user that the key represents
   * @return userId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The user that the key represents")

  public String getUserId() {
    return userId;
  }


  public void setUserId(String userId) {
    this.userId = userId;
  }


  public UserApiKey creationTime(String creationTime) {
    
    this.creationTime = creationTime;
    return this;
  }

   /**
   * Creation time in human readable format
   * @return creationTime
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Creation time in human readable format")

  public String getCreationTime() {
    return creationTime;
  }


  public void setCreationTime(String creationTime) {
    this.creationTime = creationTime;
  }


  public UserApiKey expirationTime(String expirationTime) {
    
    this.expirationTime = expirationTime;
    return this;
  }

   /**
   * Expiration time in human readable format
   * @return expirationTime
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Expiration time in human readable format")

  public String getExpirationTime() {
    return expirationTime;
  }


  public void setExpirationTime(String expirationTime) {
    this.expirationTime = expirationTime;
  }


  public UserApiKey scopes(List<String> scopes) {
    
    this.scopes = scopes;
    return this;
  }

  public UserApiKey addScopesItem(String scopesItem) {
    if (this.scopes == null) {
      this.scopes = new ArrayList<>();
    }
    this.scopes.add(scopesItem);
    return this;
  }

   /**
   * Scope of the key
   * @return scopes
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Scope of the key")

  public List<String> getScopes() {
    return scopes;
  }


  public void setScopes(List<String> scopes) {
    this.scopes = scopes;
  }


  public UserApiKey alias(String alias) {
    
    this.alias = alias;
    return this;
  }

   /**
   * Human-readable alias for the key
   * @return alias
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Human-readable alias for the key")

  public String getAlias() {
    return alias;
  }


  public void setAlias(String alias) {
    this.alias = alias;
  }


  public UserApiKey revoked(Boolean revoked) {
    
    this.revoked = revoked;
    return this;
  }

   /**
   * Whether the key has been revoked
   * @return revoked
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Whether the key has been revoked")

  public Boolean getRevoked() {
    return revoked;
  }


  public void setRevoked(Boolean revoked) {
    this.revoked = revoked;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UserApiKey userApiKey = (UserApiKey) o;
    return Objects.equals(this.key, userApiKey.key) &&
        Objects.equals(this.keyId, userApiKey.keyId) &&
        Objects.equals(this.orgId, userApiKey.orgId) &&
        Objects.equals(this.userId, userApiKey.userId) &&
        Objects.equals(this.creationTime, userApiKey.creationTime) &&
        Objects.equals(this.expirationTime, userApiKey.expirationTime) &&
        Objects.equals(this.scopes, userApiKey.scopes) &&
        Objects.equals(this.alias, userApiKey.alias) &&
        Objects.equals(this.revoked, userApiKey.revoked);
  }

  @Override
  public int hashCode() {
    return Objects.hash(key, keyId, orgId, userId, creationTime, expirationTime, scopes, alias, revoked);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UserApiKey {\n");
    sb.append("    key: ").append(toIndentedString(key)).append("\n");
    sb.append("    keyId: ").append(toIndentedString(keyId)).append("\n");
    sb.append("    orgId: ").append(toIndentedString(orgId)).append("\n");
    sb.append("    userId: ").append(toIndentedString(userId)).append("\n");
    sb.append("    creationTime: ").append(toIndentedString(creationTime)).append("\n");
    sb.append("    expirationTime: ").append(toIndentedString(expirationTime)).append("\n");
    sb.append("    scopes: ").append(toIndentedString(scopes)).append("\n");
    sb.append("    alias: ").append(toIndentedString(alias)).append("\n");
    sb.append("    revoked: ").append(toIndentedString(revoked)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

