/*
 * Decompiled with CFR 0.152.
 */
package ai.whylabs.service.api;

import ai.whylabs.service.invoker.ApiCallback;
import ai.whylabs.service.invoker.ApiClient;
import ai.whylabs.service.invoker.ApiException;
import ai.whylabs.service.invoker.ApiResponse;
import ai.whylabs.service.invoker.Configuration;
import ai.whylabs.service.invoker.Pair;
import ai.whylabs.service.model.GetAlertsPathsResponse;
import ai.whylabs.service.model.SegmentTag;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;

public class AlertsApi {
    private ApiClient localVarApiClient;

    public AlertsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AlertsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call getAlertsPathsCall(String orgId, String modelId, Long startTimestamp, Long endTimestamp, List<SegmentTag> segmentTags, String version, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/v0/organizations/{org_id}/alerts/models/{model_id}/paths".replaceAll("\\{org_id\\}", this.localVarApiClient.escapeString(orgId.toString())).replaceAll("\\{model_id\\}", this.localVarApiClient.escapeString(modelId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (segmentTags != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "segment_tags", segmentTags));
        }
        if (startTimestamp != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("start_timestamp", startTimestamp));
        }
        if (endTimestamp != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("end_timestamp", endTimestamp));
        }
        if (version != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("version", version));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"ApiKeyAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAlertsPathsValidateBeforeCall(String orgId, String modelId, Long startTimestamp, Long endTimestamp, List<SegmentTag> segmentTags, String version, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling getAlertsPaths(Async)");
        }
        if (modelId == null) {
            throw new ApiException("Missing the required parameter 'modelId' when calling getAlertsPaths(Async)");
        }
        if (startTimestamp == null) {
            throw new ApiException("Missing the required parameter 'startTimestamp' when calling getAlertsPaths(Async)");
        }
        if (endTimestamp == null) {
            throw new ApiException("Missing the required parameter 'endTimestamp' when calling getAlertsPaths(Async)");
        }
        Call localVarCall = this.getAlertsPathsCall(orgId, modelId, startTimestamp, endTimestamp, segmentTags, version, _callback);
        return localVarCall;
    }

    public GetAlertsPathsResponse getAlertsPaths(String orgId, String modelId, Long startTimestamp, Long endTimestamp, List<SegmentTag> segmentTags, String version) throws ApiException {
        ApiResponse<GetAlertsPathsResponse> localVarResp = this.getAlertsPathsWithHttpInfo(orgId, modelId, startTimestamp, endTimestamp, segmentTags, version);
        return localVarResp.getData();
    }

    public ApiResponse<GetAlertsPathsResponse> getAlertsPathsWithHttpInfo(String orgId, String modelId, Long startTimestamp, Long endTimestamp, List<SegmentTag> segmentTags, String version) throws ApiException {
        Call localVarCall = this.getAlertsPathsValidateBeforeCall(orgId, modelId, startTimestamp, endTimestamp, segmentTags, version, null);
        Type localVarReturnType = new TypeToken<GetAlertsPathsResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getAlertsPathsAsync(String orgId, String modelId, Long startTimestamp, Long endTimestamp, List<SegmentTag> segmentTags, String version, ApiCallback<GetAlertsPathsResponse> _callback) throws ApiException {
        Call localVarCall = this.getAlertsPathsValidateBeforeCall(orgId, modelId, startTimestamp, endTimestamp, segmentTags, version, _callback);
        Type localVarReturnType = new TypeToken<GetAlertsPathsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

