/*
 * Decompiled with CFR 0.152.
 */
package ai.whylabs.service.api;

import ai.whylabs.service.invoker.ApiCallback;
import ai.whylabs.service.invoker.ApiClient;
import ai.whylabs.service.invoker.ApiException;
import ai.whylabs.service.invoker.ApiResponse;
import ai.whylabs.service.invoker.Configuration;
import ai.whylabs.service.invoker.Pair;
import ai.whylabs.service.model.AsyncLogResponse;
import ai.whylabs.service.model.LogAsyncRequest;
import ai.whylabs.service.model.LogReferenceRequest;
import ai.whylabs.service.model.LogReferenceResponse;
import ai.whylabs.service.model.LogResponse;
import ai.whylabs.service.model.SegmentTag;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;

public class LogApi {
    private ApiClient localVarApiClient;

    public LogApi() {
        this(Configuration.getDefaultApiClient());
    }

    public LogApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call logCall(String orgId, String modelId, Long datasetTimestamp, List<SegmentTag> segmentTags, String segmentTagsJson, File file, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/v0/organizations/{org_id}/log".replaceAll("\\{org_id\\}", this.localVarApiClient.escapeString(orgId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (file != null) {
            localVarFormParams.put("file", file);
        }
        if (modelId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("model_id", modelId));
        }
        if (datasetTimestamp != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dataset_timestamp", datasetTimestamp));
        }
        if (segmentTags != null) {
            localVarCollectionQueryParams.addAll(this.localVarApiClient.parameterToPairs("multi", "segment_tags", segmentTags));
        }
        if (segmentTagsJson != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("segment_tags_json", segmentTagsJson));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"ApiKeyAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call logValidateBeforeCall(String orgId, String modelId, Long datasetTimestamp, List<SegmentTag> segmentTags, String segmentTagsJson, File file, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling log(Async)");
        }
        if (modelId == null) {
            throw new ApiException("Missing the required parameter 'modelId' when calling log(Async)");
        }
        Call localVarCall = this.logCall(orgId, modelId, datasetTimestamp, segmentTags, segmentTagsJson, file, _callback);
        return localVarCall;
    }

    public LogResponse log(String orgId, String modelId, Long datasetTimestamp, List<SegmentTag> segmentTags, String segmentTagsJson, File file) throws ApiException {
        ApiResponse<LogResponse> localVarResp = this.logWithHttpInfo(orgId, modelId, datasetTimestamp, segmentTags, segmentTagsJson, file);
        return localVarResp.getData();
    }

    public ApiResponse<LogResponse> logWithHttpInfo(String orgId, String modelId, Long datasetTimestamp, List<SegmentTag> segmentTags, String segmentTagsJson, File file) throws ApiException {
        Call localVarCall = this.logValidateBeforeCall(orgId, modelId, datasetTimestamp, segmentTags, segmentTagsJson, file, null);
        Type localVarReturnType = new TypeToken<LogResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call logAsync(String orgId, String modelId, Long datasetTimestamp, List<SegmentTag> segmentTags, String segmentTagsJson, File file, ApiCallback<LogResponse> _callback) throws ApiException {
        Call localVarCall = this.logValidateBeforeCall(orgId, modelId, datasetTimestamp, segmentTags, segmentTagsJson, file, _callback);
        Type localVarReturnType = new TypeToken<LogResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call logAsyncCall(String orgId, String datasetId, LogAsyncRequest logAsyncRequest, ApiCallback _callback) throws ApiException {
        LogAsyncRequest localVarPostBody = logAsyncRequest;
        String localVarPath = "/v0/organizations/{org_id}/log/async/{dataset_id}".replaceAll("\\{org_id\\}", this.localVarApiClient.escapeString(orgId.toString())).replaceAll("\\{dataset_id\\}", this.localVarApiClient.escapeString(datasetId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"ApiKeyAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call logAsyncValidateBeforeCall(String orgId, String datasetId, LogAsyncRequest logAsyncRequest, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling logAsync(Async)");
        }
        if (datasetId == null) {
            throw new ApiException("Missing the required parameter 'datasetId' when calling logAsync(Async)");
        }
        if (logAsyncRequest == null) {
            throw new ApiException("Missing the required parameter 'logAsyncRequest' when calling logAsync(Async)");
        }
        Call localVarCall = this.logAsyncCall(orgId, datasetId, logAsyncRequest, _callback);
        return localVarCall;
    }

    public AsyncLogResponse logAsync(String orgId, String datasetId, LogAsyncRequest logAsyncRequest) throws ApiException {
        ApiResponse<AsyncLogResponse> localVarResp = this.logAsyncWithHttpInfo(orgId, datasetId, logAsyncRequest);
        return localVarResp.getData();
    }

    public ApiResponse<AsyncLogResponse> logAsyncWithHttpInfo(String orgId, String datasetId, LogAsyncRequest logAsyncRequest) throws ApiException {
        Call localVarCall = this.logAsyncValidateBeforeCall(orgId, datasetId, logAsyncRequest, null);
        Type localVarReturnType = new TypeToken<AsyncLogResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call logAsyncAsync(String orgId, String datasetId, LogAsyncRequest logAsyncRequest, ApiCallback<AsyncLogResponse> _callback) throws ApiException {
        Call localVarCall = this.logAsyncValidateBeforeCall(orgId, datasetId, logAsyncRequest, _callback);
        Type localVarReturnType = new TypeToken<AsyncLogResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call logReferenceCall(String orgId, String modelId, LogReferenceRequest logReferenceRequest, ApiCallback _callback) throws ApiException {
        LogReferenceRequest localVarPostBody = logReferenceRequest;
        String localVarPath = "/v0/organizations/{org_id}/log/reference/{model_id}".replaceAll("\\{org_id\\}", this.localVarApiClient.escapeString(orgId.toString())).replaceAll("\\{model_id\\}", this.localVarApiClient.escapeString(modelId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"ApiKeyAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call logReferenceValidateBeforeCall(String orgId, String modelId, LogReferenceRequest logReferenceRequest, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling logReference(Async)");
        }
        if (modelId == null) {
            throw new ApiException("Missing the required parameter 'modelId' when calling logReference(Async)");
        }
        if (logReferenceRequest == null) {
            throw new ApiException("Missing the required parameter 'logReferenceRequest' when calling logReference(Async)");
        }
        Call localVarCall = this.logReferenceCall(orgId, modelId, logReferenceRequest, _callback);
        return localVarCall;
    }

    public LogReferenceResponse logReference(String orgId, String modelId, LogReferenceRequest logReferenceRequest) throws ApiException {
        ApiResponse<LogReferenceResponse> localVarResp = this.logReferenceWithHttpInfo(orgId, modelId, logReferenceRequest);
        return localVarResp.getData();
    }

    public ApiResponse<LogReferenceResponse> logReferenceWithHttpInfo(String orgId, String modelId, LogReferenceRequest logReferenceRequest) throws ApiException {
        Call localVarCall = this.logReferenceValidateBeforeCall(orgId, modelId, logReferenceRequest, null);
        Type localVarReturnType = new TypeToken<LogReferenceResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call logReferenceAsync(String orgId, String modelId, LogReferenceRequest logReferenceRequest, ApiCallback<LogReferenceResponse> _callback) throws ApiException {
        Call localVarCall = this.logReferenceValidateBeforeCall(orgId, modelId, logReferenceRequest, _callback);
        Type localVarReturnType = new TypeToken<LogReferenceResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call removeStagedLogEntryCall(String orgId, String logEntryId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v0/organizations/{org_id}/log/log-entry-id/{log_entry_id}".replaceAll("\\{org_id\\}", this.localVarApiClient.escapeString(orgId.toString())).replaceAll("\\{log_entry_id\\}", this.localVarApiClient.escapeString(logEntryId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"ApiKeyAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call removeStagedLogEntryValidateBeforeCall(String orgId, String logEntryId, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling removeStagedLogEntry(Async)");
        }
        if (logEntryId == null) {
            throw new ApiException("Missing the required parameter 'logEntryId' when calling removeStagedLogEntry(Async)");
        }
        Call localVarCall = this.removeStagedLogEntryCall(orgId, logEntryId, _callback);
        return localVarCall;
    }

    public LogResponse removeStagedLogEntry(String orgId, String logEntryId) throws ApiException {
        ApiResponse<LogResponse> localVarResp = this.removeStagedLogEntryWithHttpInfo(orgId, logEntryId);
        return localVarResp.getData();
    }

    public ApiResponse<LogResponse> removeStagedLogEntryWithHttpInfo(String orgId, String logEntryId) throws ApiException {
        Call localVarCall = this.removeStagedLogEntryValidateBeforeCall(orgId, logEntryId, null);
        Type localVarReturnType = new TypeToken<LogResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call removeStagedLogEntryAsync(String orgId, String logEntryId, ApiCallback<LogResponse> _callback) throws ApiException {
        Call localVarCall = this.removeStagedLogEntryValidateBeforeCall(orgId, logEntryId, _callback);
        Type localVarReturnType = new TypeToken<LogResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

