/*
 * Decompiled with CFR 0.152.
 */
package ai.whylabs.service.api;

import ai.whylabs.service.invoker.ApiCallback;
import ai.whylabs.service.invoker.ApiClient;
import ai.whylabs.service.invoker.ApiException;
import ai.whylabs.service.invoker.ApiResponse;
import ai.whylabs.service.invoker.Configuration;
import ai.whylabs.service.invoker.Pair;
import ai.whylabs.service.model.ListModelsResponse;
import ai.whylabs.service.model.ListSegmentsResponse;
import ai.whylabs.service.model.ModelMetadata;
import ai.whylabs.service.model.ModelType;
import ai.whylabs.service.model.SegmentMetadata;
import ai.whylabs.service.model.SegmentTag;
import ai.whylabs.service.model.TimePeriod;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;

public class ModelsApi {
    private ApiClient localVarApiClient;

    public ModelsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ModelsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call createModelCall(String orgId, String modelName, TimePeriod timePeriod, ModelType modelType, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/v0/organizations/{org_id}/models".replaceAll("\\{org_id\\}", this.localVarApiClient.escapeString(orgId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (modelName != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("model_name", modelName));
        }
        if (timePeriod != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("time_period", (Object)timePeriod));
        }
        if (modelType != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("model_type", (Object)modelType));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"ApiKeyAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createModelValidateBeforeCall(String orgId, String modelName, TimePeriod timePeriod, ModelType modelType, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling createModel(Async)");
        }
        if (modelName == null) {
            throw new ApiException("Missing the required parameter 'modelName' when calling createModel(Async)");
        }
        if (timePeriod == null) {
            throw new ApiException("Missing the required parameter 'timePeriod' when calling createModel(Async)");
        }
        Call localVarCall = this.createModelCall(orgId, modelName, timePeriod, modelType, _callback);
        return localVarCall;
    }

    public ModelMetadata createModel(String orgId, String modelName, TimePeriod timePeriod, ModelType modelType) throws ApiException {
        ApiResponse<ModelMetadata> localVarResp = this.createModelWithHttpInfo(orgId, modelName, timePeriod, modelType);
        return localVarResp.getData();
    }

    public ApiResponse<ModelMetadata> createModelWithHttpInfo(String orgId, String modelName, TimePeriod timePeriod, ModelType modelType) throws ApiException {
        Call localVarCall = this.createModelValidateBeforeCall(orgId, modelName, timePeriod, modelType, null);
        Type localVarReturnType = new TypeToken<ModelMetadata>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createModelAsync(String orgId, String modelName, TimePeriod timePeriod, ModelType modelType, ApiCallback<ModelMetadata> _callback) throws ApiException {
        Call localVarCall = this.createModelValidateBeforeCall(orgId, modelName, timePeriod, modelType, _callback);
        Type localVarReturnType = new TypeToken<ModelMetadata>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deactivateModelCall(String orgId, String modelId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v0/organizations/{org_id}/models/{model_id}".replaceAll("\\{org_id\\}", this.localVarApiClient.escapeString(orgId.toString())).replaceAll("\\{model_id\\}", this.localVarApiClient.escapeString(modelId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"ApiKeyAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deactivateModelValidateBeforeCall(String orgId, String modelId, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling deactivateModel(Async)");
        }
        if (modelId == null) {
            throw new ApiException("Missing the required parameter 'modelId' when calling deactivateModel(Async)");
        }
        Call localVarCall = this.deactivateModelCall(orgId, modelId, _callback);
        return localVarCall;
    }

    public ModelMetadata deactivateModel(String orgId, String modelId) throws ApiException {
        ApiResponse<ModelMetadata> localVarResp = this.deactivateModelWithHttpInfo(orgId, modelId);
        return localVarResp.getData();
    }

    public ApiResponse<ModelMetadata> deactivateModelWithHttpInfo(String orgId, String modelId) throws ApiException {
        Call localVarCall = this.deactivateModelValidateBeforeCall(orgId, modelId, null);
        Type localVarReturnType = new TypeToken<ModelMetadata>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deactivateModelAsync(String orgId, String modelId, ApiCallback<ModelMetadata> _callback) throws ApiException {
        Call localVarCall = this.deactivateModelValidateBeforeCall(orgId, modelId, _callback);
        Type localVarReturnType = new TypeToken<ModelMetadata>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getModelCall(String orgId, String modelId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v0/organizations/{org_id}/models/{model_id}".replaceAll("\\{org_id\\}", this.localVarApiClient.escapeString(orgId.toString())).replaceAll("\\{model_id\\}", this.localVarApiClient.escapeString(modelId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"ApiKeyAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getModelValidateBeforeCall(String orgId, String modelId, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling getModel(Async)");
        }
        if (modelId == null) {
            throw new ApiException("Missing the required parameter 'modelId' when calling getModel(Async)");
        }
        Call localVarCall = this.getModelCall(orgId, modelId, _callback);
        return localVarCall;
    }

    public ModelMetadata getModel(String orgId, String modelId) throws ApiException {
        ApiResponse<ModelMetadata> localVarResp = this.getModelWithHttpInfo(orgId, modelId);
        return localVarResp.getData();
    }

    public ApiResponse<ModelMetadata> getModelWithHttpInfo(String orgId, String modelId) throws ApiException {
        Call localVarCall = this.getModelValidateBeforeCall(orgId, modelId, null);
        Type localVarReturnType = new TypeToken<ModelMetadata>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getModelAsync(String orgId, String modelId, ApiCallback<ModelMetadata> _callback) throws ApiException {
        Call localVarCall = this.getModelValidateBeforeCall(orgId, modelId, _callback);
        Type localVarReturnType = new TypeToken<ModelMetadata>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listModelsCall(String orgId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v0/organizations/{org_id}/models".replaceAll("\\{org_id\\}", this.localVarApiClient.escapeString(orgId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"ApiKeyAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listModelsValidateBeforeCall(String orgId, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling listModels(Async)");
        }
        Call localVarCall = this.listModelsCall(orgId, _callback);
        return localVarCall;
    }

    public ListModelsResponse listModels(String orgId) throws ApiException {
        ApiResponse<ListModelsResponse> localVarResp = this.listModelsWithHttpInfo(orgId);
        return localVarResp.getData();
    }

    public ApiResponse<ListModelsResponse> listModelsWithHttpInfo(String orgId) throws ApiException {
        Call localVarCall = this.listModelsValidateBeforeCall(orgId, null);
        Type localVarReturnType = new TypeToken<ListModelsResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listModelsAsync(String orgId, ApiCallback<ListModelsResponse> _callback) throws ApiException {
        Call localVarCall = this.listModelsValidateBeforeCall(orgId, _callback);
        Type localVarReturnType = new TypeToken<ListModelsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call listSegmentsCall(String orgId, String modelId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v0/organizations/{org_id}/models/{model_id}/segments".replaceAll("\\{org_id\\}", this.localVarApiClient.escapeString(orgId.toString())).replaceAll("\\{model_id\\}", this.localVarApiClient.escapeString(modelId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"ApiKeyAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listSegmentsValidateBeforeCall(String orgId, String modelId, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling listSegments(Async)");
        }
        if (modelId == null) {
            throw new ApiException("Missing the required parameter 'modelId' when calling listSegments(Async)");
        }
        Call localVarCall = this.listSegmentsCall(orgId, modelId, _callback);
        return localVarCall;
    }

    public ListSegmentsResponse listSegments(String orgId, String modelId) throws ApiException {
        ApiResponse<ListSegmentsResponse> localVarResp = this.listSegmentsWithHttpInfo(orgId, modelId);
        return localVarResp.getData();
    }

    public ApiResponse<ListSegmentsResponse> listSegmentsWithHttpInfo(String orgId, String modelId) throws ApiException {
        Call localVarCall = this.listSegmentsValidateBeforeCall(orgId, modelId, null);
        Type localVarReturnType = new TypeToken<ListSegmentsResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call listSegmentsAsync(String orgId, String modelId, ApiCallback<ListSegmentsResponse> _callback) throws ApiException {
        Call localVarCall = this.listSegmentsValidateBeforeCall(orgId, modelId, _callback);
        Type localVarReturnType = new TypeToken<ListSegmentsResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call putSegmentsCall(String orgId, String modelId, List<SegmentTag> segmentTag, ApiCallback _callback) throws ApiException {
        List<SegmentTag> localVarPostBody = segmentTag;
        String localVarPath = "/v0/organizations/{org_id}/models/{model_id}/segments".replaceAll("\\{org_id\\}", this.localVarApiClient.escapeString(orgId.toString())).replaceAll("\\{model_id\\}", this.localVarApiClient.escapeString(modelId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"ApiKeyAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call putSegmentsValidateBeforeCall(String orgId, String modelId, List<SegmentTag> segmentTag, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling putSegments(Async)");
        }
        if (modelId == null) {
            throw new ApiException("Missing the required parameter 'modelId' when calling putSegments(Async)");
        }
        if (segmentTag == null) {
            throw new ApiException("Missing the required parameter 'segmentTag' when calling putSegments(Async)");
        }
        Call localVarCall = this.putSegmentsCall(orgId, modelId, segmentTag, _callback);
        return localVarCall;
    }

    public SegmentMetadata putSegments(String orgId, String modelId, List<SegmentTag> segmentTag) throws ApiException {
        ApiResponse<SegmentMetadata> localVarResp = this.putSegmentsWithHttpInfo(orgId, modelId, segmentTag);
        return localVarResp.getData();
    }

    public ApiResponse<SegmentMetadata> putSegmentsWithHttpInfo(String orgId, String modelId, List<SegmentTag> segmentTag) throws ApiException {
        Call localVarCall = this.putSegmentsValidateBeforeCall(orgId, modelId, segmentTag, null);
        Type localVarReturnType = new TypeToken<SegmentMetadata>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call putSegmentsAsync(String orgId, String modelId, List<SegmentTag> segmentTag, ApiCallback<SegmentMetadata> _callback) throws ApiException {
        Call localVarCall = this.putSegmentsValidateBeforeCall(orgId, modelId, segmentTag, _callback);
        Type localVarReturnType = new TypeToken<SegmentMetadata>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateModelCall(String orgId, String modelId, String modelName, TimePeriod timePeriod, ModelType modelType, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/v0/organizations/{org_id}/models/{model_id}".replaceAll("\\{org_id\\}", this.localVarApiClient.escapeString(orgId.toString())).replaceAll("\\{model_id\\}", this.localVarApiClient.escapeString(modelId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (modelName != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("model_name", modelName));
        }
        if (timePeriod != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("time_period", (Object)timePeriod));
        }
        if (modelType != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("model_type", (Object)modelType));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"ApiKeyAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateModelValidateBeforeCall(String orgId, String modelId, String modelName, TimePeriod timePeriod, ModelType modelType, ApiCallback _callback) throws ApiException {
        if (orgId == null) {
            throw new ApiException("Missing the required parameter 'orgId' when calling updateModel(Async)");
        }
        if (modelId == null) {
            throw new ApiException("Missing the required parameter 'modelId' when calling updateModel(Async)");
        }
        if (modelName == null) {
            throw new ApiException("Missing the required parameter 'modelName' when calling updateModel(Async)");
        }
        if (timePeriod == null) {
            throw new ApiException("Missing the required parameter 'timePeriod' when calling updateModel(Async)");
        }
        Call localVarCall = this.updateModelCall(orgId, modelId, modelName, timePeriod, modelType, _callback);
        return localVarCall;
    }

    public ModelMetadata updateModel(String orgId, String modelId, String modelName, TimePeriod timePeriod, ModelType modelType) throws ApiException {
        ApiResponse<ModelMetadata> localVarResp = this.updateModelWithHttpInfo(orgId, modelId, modelName, timePeriod, modelType);
        return localVarResp.getData();
    }

    public ApiResponse<ModelMetadata> updateModelWithHttpInfo(String orgId, String modelId, String modelName, TimePeriod timePeriod, ModelType modelType) throws ApiException {
        Call localVarCall = this.updateModelValidateBeforeCall(orgId, modelId, modelName, timePeriod, modelType, null);
        Type localVarReturnType = new TypeToken<ModelMetadata>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateModelAsync(String orgId, String modelId, String modelName, TimePeriod timePeriod, ModelType modelType, ApiCallback<ModelMetadata> _callback) throws ApiException {
        Call localVarCall = this.updateModelValidateBeforeCall(orgId, modelId, modelName, timePeriod, modelType, _callback);
        Type localVarReturnType = new TypeToken<ModelMetadata>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

