/*
 * Decompiled with CFR 0.152.
 */
package ai.whylabs.service.api;

import ai.whylabs.service.invoker.ApiCallback;
import ai.whylabs.service.invoker.ApiClient;
import ai.whylabs.service.invoker.ApiException;
import ai.whylabs.service.invoker.ApiResponse;
import ai.whylabs.service.invoker.Configuration;
import ai.whylabs.service.invoker.Pair;
import ai.whylabs.service.model.CloseSessionResponse;
import ai.whylabs.service.model.CreateSessionResponse;
import ai.whylabs.service.model.CreateSessionUploadResponse;
import ai.whylabs.service.model.GetSessionResponse;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class SessionsApi {
    private ApiClient localVarApiClient;

    public SessionsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SessionsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call closeSessionCall(String sessionToken, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v0/sessions/{session_token}/close".replaceAll("\\{session_token\\}", this.localVarApiClient.escapeString(sessionToken.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call closeSessionValidateBeforeCall(String sessionToken, ApiCallback _callback) throws ApiException {
        if (sessionToken == null) {
            throw new ApiException("Missing the required parameter 'sessionToken' when calling closeSession(Async)");
        }
        Call localVarCall = this.closeSessionCall(sessionToken, _callback);
        return localVarCall;
    }

    public CloseSessionResponse closeSession(String sessionToken) throws ApiException {
        ApiResponse<CloseSessionResponse> localVarResp = this.closeSessionWithHttpInfo(sessionToken);
        return localVarResp.getData();
    }

    public ApiResponse<CloseSessionResponse> closeSessionWithHttpInfo(String sessionToken) throws ApiException {
        Call localVarCall = this.closeSessionValidateBeforeCall(sessionToken, null);
        Type localVarReturnType = new TypeToken<CloseSessionResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call closeSessionAsync(String sessionToken, ApiCallback<CloseSessionResponse> _callback) throws ApiException {
        Call localVarCall = this.closeSessionValidateBeforeCall(sessionToken, _callback);
        Type localVarReturnType = new TypeToken<CloseSessionResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createDatasetProfileUploadCall(String sessionToken, Long datasetTimestamp, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/v0/sessions/{session_token}/upload".replaceAll("\\{session_token\\}", this.localVarApiClient.escapeString(sessionToken.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (datasetTimestamp != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dataset_timestamp", datasetTimestamp));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createDatasetProfileUploadValidateBeforeCall(String sessionToken, Long datasetTimestamp, ApiCallback _callback) throws ApiException {
        if (sessionToken == null) {
            throw new ApiException("Missing the required parameter 'sessionToken' when calling createDatasetProfileUpload(Async)");
        }
        Call localVarCall = this.createDatasetProfileUploadCall(sessionToken, datasetTimestamp, _callback);
        return localVarCall;
    }

    public CreateSessionUploadResponse createDatasetProfileUpload(String sessionToken, Long datasetTimestamp) throws ApiException {
        ApiResponse<CreateSessionUploadResponse> localVarResp = this.createDatasetProfileUploadWithHttpInfo(sessionToken, datasetTimestamp);
        return localVarResp.getData();
    }

    public ApiResponse<CreateSessionUploadResponse> createDatasetProfileUploadWithHttpInfo(String sessionToken, Long datasetTimestamp) throws ApiException {
        Call localVarCall = this.createDatasetProfileUploadValidateBeforeCall(sessionToken, datasetTimestamp, null);
        Type localVarReturnType = new TypeToken<CreateSessionUploadResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createDatasetProfileUploadAsync(String sessionToken, Long datasetTimestamp, ApiCallback<CreateSessionUploadResponse> _callback) throws ApiException {
        Call localVarCall = this.createDatasetProfileUploadValidateBeforeCall(sessionToken, datasetTimestamp, _callback);
        Type localVarReturnType = new TypeToken<CreateSessionUploadResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call createSessionCall(ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v0/sessions";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createSessionValidateBeforeCall(ApiCallback _callback) throws ApiException {
        Call localVarCall = this.createSessionCall(_callback);
        return localVarCall;
    }

    public CreateSessionResponse createSession() throws ApiException {
        ApiResponse<CreateSessionResponse> localVarResp = this.createSessionWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<CreateSessionResponse> createSessionWithHttpInfo() throws ApiException {
        Call localVarCall = this.createSessionValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<CreateSessionResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createSessionAsync(ApiCallback<CreateSessionResponse> _callback) throws ApiException {
        Call localVarCall = this.createSessionValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<CreateSessionResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getSessionCall(String sessionToken, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/v0/sessions/{session_token}".replaceAll("\\{session_token\\}", this.localVarApiClient.escapeString(sessionToken.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"ApiKeyAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getSessionValidateBeforeCall(String sessionToken, ApiCallback _callback) throws ApiException {
        if (sessionToken == null) {
            throw new ApiException("Missing the required parameter 'sessionToken' when calling getSession(Async)");
        }
        Call localVarCall = this.getSessionCall(sessionToken, _callback);
        return localVarCall;
    }

    public GetSessionResponse getSession(String sessionToken) throws ApiException {
        ApiResponse<GetSessionResponse> localVarResp = this.getSessionWithHttpInfo(sessionToken);
        return localVarResp.getData();
    }

    public ApiResponse<GetSessionResponse> getSessionWithHttpInfo(String sessionToken) throws ApiException {
        Call localVarCall = this.getSessionValidateBeforeCall(sessionToken, null);
        Type localVarReturnType = new TypeToken<GetSessionResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getSessionAsync(String sessionToken, ApiCallback<GetSessionResponse> _callback) throws ApiException {
        Call localVarCall = this.getSessionValidateBeforeCall(sessionToken, _callback);
        Type localVarReturnType = new TypeToken<GetSessionResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

