/*
 * Decompiled with CFR 0.152.
 */
package ai.whylabs.service.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

@JsonAdapter(value=Adapter.class)
public enum ModelType {
    CLASSIFICATION("CLASSIFICATION"),
    REGRESSION("REGRESSION"),
    EMBEDDINGS("EMBEDDINGS");

    private String value;

    private ModelType(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ModelType fromValue(String value) {
        for (ModelType b : ModelType.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter
    extends TypeAdapter<ModelType> {
        public void write(JsonWriter jsonWriter, ModelType enumeration) throws IOException {
            jsonWriter.value(enumeration.getValue());
        }

        public ModelType read(JsonReader jsonReader) throws IOException {
            String value = jsonReader.nextString();
            return ModelType.fromValue(value);
        }
    }
}

