/*
 * Decompiled with CFR 0.152.
 */
package ai.whylabs.service.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Response for getting sessions.")
public class SessionMetadata {
    public static final String SERIALIZED_NAME_SESSION_ID = "sessionId";
    @SerializedName(value="sessionId")
    private String sessionId;
    public static final String SERIALIZED_NAME_ORG_ID = "orgId";
    @SerializedName(value="orgId")
    private String orgId;
    public static final String SERIALIZED_NAME_MODEL_ID = "modelId";
    @SerializedName(value="modelId")
    private String modelId;
    public static final String SERIALIZED_NAME_CLOSED = "closed";
    @SerializedName(value="closed")
    private Boolean closed;
    public static final String SERIALIZED_NAME_USER_ID = "userId";
    @SerializedName(value="userId")
    private String userId;

    public SessionMetadata sessionId(String sessionId) {
        this.sessionId = sessionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the session")
    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public SessionMetadata orgId(String orgId) {
        this.orgId = orgId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The org id of the session")
    public String getOrgId() {
        return this.orgId;
    }

    public void setOrgId(String orgId) {
        this.orgId = orgId;
    }

    public SessionMetadata modelId(String modelId) {
        this.modelId = modelId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The model id of the session. There should only be a single model.")
    public String getModelId() {
        return this.modelId;
    }

    public void setModelId(String modelId) {
        this.modelId = modelId;
    }

    public SessionMetadata closed(Boolean closed) {
        this.closed = closed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether or not the session is open for uploading dataset profiles to.")
    public Boolean getClosed() {
        return this.closed;
    }

    public void setClosed(Boolean closed) {
        this.closed = closed;
    }

    public SessionMetadata userId(String userId) {
        this.userId = userId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The generated user id for the session.")
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SessionMetadata sessionMetadata = (SessionMetadata)o;
        return Objects.equals(this.sessionId, sessionMetadata.sessionId) && Objects.equals(this.orgId, sessionMetadata.orgId) && Objects.equals(this.modelId, sessionMetadata.modelId) && Objects.equals(this.closed, sessionMetadata.closed) && Objects.equals(this.userId, sessionMetadata.userId);
    }

    public int hashCode() {
        return Objects.hash(this.sessionId, this.orgId, this.modelId, this.closed, this.userId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SessionMetadata {\n");
        sb.append("    sessionId: ").append(this.toIndentedString(this.sessionId)).append("\n");
        sb.append("    orgId: ").append(this.toIndentedString(this.orgId)).append("\n");
        sb.append("    modelId: ").append(this.toIndentedString(this.modelId)).append("\n");
        sb.append("    closed: ").append(this.toIndentedString(this.closed)).append("\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

