/*
 * Decompiled with CFR 0.152.
 */
package ai.whylabs.service.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Response when creating an API key successfully")
public class UserApiKey {
    public static final String SERIALIZED_NAME_KEY = "key";
    @SerializedName(value="key")
    private String key;
    public static final String SERIALIZED_NAME_KEY_ID = "keyId";
    @SerializedName(value="keyId")
    private String keyId;
    public static final String SERIALIZED_NAME_ORG_ID = "orgId";
    @SerializedName(value="orgId")
    private String orgId;
    public static final String SERIALIZED_NAME_USER_ID = "userId";
    @SerializedName(value="userId")
    private String userId;
    public static final String SERIALIZED_NAME_CREATION_TIME = "creationTime";
    @SerializedName(value="creationTime")
    private String creationTime;
    public static final String SERIALIZED_NAME_EXPIRATION_TIME = "expirationTime";
    @SerializedName(value="expirationTime")
    private String expirationTime;
    public static final String SERIALIZED_NAME_SCOPES = "scopes";
    @SerializedName(value="scopes")
    private List<String> scopes = null;
    public static final String SERIALIZED_NAME_ALIAS = "alias";
    @SerializedName(value="alias")
    private String alias;
    public static final String SERIALIZED_NAME_REVOKED = "revoked";
    @SerializedName(value="revoked")
    private Boolean revoked;

    public UserApiKey key(String key) {
        this.key = key;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The full value of the key. This is not persisted in the system")
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public UserApiKey keyId(String keyId) {
        this.keyId = keyId;
        return this;
    }

    @ApiModelProperty(required=true, value="The key id. Can be used to identify keys for a given user")
    public String getKeyId() {
        return this.keyId;
    }

    public void setKeyId(String keyId) {
        this.keyId = keyId;
    }

    public UserApiKey orgId(String orgId) {
        this.orgId = orgId;
        return this;
    }

    @ApiModelProperty(required=true, value="The organization that the key belongs to")
    public String getOrgId() {
        return this.orgId;
    }

    public void setOrgId(String orgId) {
        this.orgId = orgId;
    }

    public UserApiKey userId(String userId) {
        this.userId = userId;
        return this;
    }

    @ApiModelProperty(required=true, value="The user that the key represents")
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public UserApiKey creationTime(String creationTime) {
        this.creationTime = creationTime;
        return this;
    }

    @ApiModelProperty(required=true, value="Creation time in human readable format")
    public String getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(String creationTime) {
        this.creationTime = creationTime;
    }

    public UserApiKey expirationTime(String expirationTime) {
        this.expirationTime = expirationTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Expiration time in human readable format")
    public String getExpirationTime() {
        return this.expirationTime;
    }

    public void setExpirationTime(String expirationTime) {
        this.expirationTime = expirationTime;
    }

    public UserApiKey scopes(List<String> scopes) {
        this.scopes = scopes;
        return this;
    }

    public UserApiKey addScopesItem(String scopesItem) {
        if (this.scopes == null) {
            this.scopes = new ArrayList<String>();
        }
        this.scopes.add(scopesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Scope of the key")
    public List<String> getScopes() {
        return this.scopes;
    }

    public void setScopes(List<String> scopes) {
        this.scopes = scopes;
    }

    public UserApiKey alias(String alias) {
        this.alias = alias;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Human-readable alias for the key")
    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public UserApiKey revoked(Boolean revoked) {
        this.revoked = revoked;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether the key has been revoked")
    public Boolean getRevoked() {
        return this.revoked;
    }

    public void setRevoked(Boolean revoked) {
        this.revoked = revoked;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserApiKey userApiKey = (UserApiKey)o;
        return Objects.equals(this.key, userApiKey.key) && Objects.equals(this.keyId, userApiKey.keyId) && Objects.equals(this.orgId, userApiKey.orgId) && Objects.equals(this.userId, userApiKey.userId) && Objects.equals(this.creationTime, userApiKey.creationTime) && Objects.equals(this.expirationTime, userApiKey.expirationTime) && Objects.equals(this.scopes, userApiKey.scopes) && Objects.equals(this.alias, userApiKey.alias) && Objects.equals(this.revoked, userApiKey.revoked);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.keyId, this.orgId, this.userId, this.creationTime, this.expirationTime, this.scopes, this.alias, this.revoked);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserApiKey {\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    keyId: ").append(this.toIndentedString(this.keyId)).append("\n");
        sb.append("    orgId: ").append(this.toIndentedString(this.orgId)).append("\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("    creationTime: ").append(this.toIndentedString(this.creationTime)).append("\n");
        sb.append("    expirationTime: ").append(this.toIndentedString(this.expirationTime)).append("\n");
        sb.append("    scopes: ").append(this.toIndentedString(this.scopes)).append("\n");
        sb.append("    alias: ").append(this.toIndentedString(this.alias)).append("\n");
        sb.append("    revoked: ").append(this.toIndentedString(this.revoked)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

