/*
 * Decompiled with CFR 0.152.
 */
package com.whylogs.core.statistics;

import com.google.protobuf.Int64Value;
import com.whylogs.core.message.Counters;
import java.util.Optional;

public class CountersTracker {
    private long count;
    private long trueCount;
    private long nullCount;

    public void incrementCount() {
        ++this.count;
    }

    public void incrementTrue() {
        ++this.trueCount;
    }

    public void incrementNull() {
        ++this.nullCount;
    }

    public CountersTracker merge(CountersTracker other) {
        CountersTracker result = new CountersTracker();
        result.count = this.count + other.count;
        result.trueCount = this.trueCount + other.trueCount;
        result.nullCount = this.nullCount + other.nullCount;
        return result;
    }

    public Counters.Builder toProtobuf() {
        Counters.Builder countersBuilder = Counters.newBuilder().setCount(this.count);
        if (this.trueCount > 0L) {
            countersBuilder.setTrueCount(Int64Value.of((long)this.trueCount));
        }
        if (this.nullCount > 0L) {
            countersBuilder.setTrueCount(Int64Value.of((long)this.nullCount));
        }
        return countersBuilder;
    }

    public static CountersTracker fromProtobuf(Counters message) {
        CountersTracker tracker = new CountersTracker();
        tracker.count = message.getCount();
        tracker.trueCount = Optional.ofNullable(message.getTrueCount()).map(Int64Value::getValue).orElse(0L);
        tracker.nullCount = Optional.ofNullable(message.getNullCount()).map(Int64Value::getValue).orElse(0L);
        return tracker;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CountersTracker)) {
            return false;
        }
        CountersTracker other = (CountersTracker)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCount() != other.getCount()) {
            return false;
        }
        if (this.getTrueCount() != other.getTrueCount()) {
            return false;
        }
        return this.getNullCount() == other.getNullCount();
    }

    protected boolean canEqual(Object other) {
        return other instanceof CountersTracker;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $count = this.getCount();
        result = result * 59 + (int)($count >>> 32 ^ $count);
        long $trueCount = this.getTrueCount();
        result = result * 59 + (int)($trueCount >>> 32 ^ $trueCount);
        long $nullCount = this.getNullCount();
        result = result * 59 + (int)($nullCount >>> 32 ^ $nullCount);
        return result;
    }

    public long getCount() {
        return this.count;
    }

    public long getTrueCount() {
        return this.trueCount;
    }

    public long getNullCount() {
        return this.nullCount;
    }
}

