/*
 * Decompiled with CFR 0.152.
 */
package com.whylogs.core.statistics;

import com.google.protobuf.ByteString;
import com.whylogs.core.message.NumbersMessage;
import com.whylogs.core.statistics.datatypes.DoubleTracker;
import com.whylogs.core.statistics.datatypes.LongTracker;
import com.whylogs.core.statistics.datatypes.VarianceTracker;
import java.util.Optional;
import org.apache.datasketches.kll.KllFloatsSketch;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.theta.Sketch;
import org.apache.datasketches.theta.Union;
import org.apache.datasketches.theta.UpdateSketch;

public class NumberTracker {
    VarianceTracker variance;
    DoubleTracker doubles;
    LongTracker longs;
    KllFloatsSketch histogram;
    UpdateSketch thetaSketch;

    public NumberTracker() {
        this.variance = new VarianceTracker();
        this.doubles = new DoubleTracker();
        this.longs = new LongTracker();
        this.thetaSketch = UpdateSketch.builder().build();
        this.histogram = new KllFloatsSketch(256);
    }

    public void track(Number number) {
        float dValue = number.floatValue();
        this.variance.update(dValue);
        this.thetaSketch.update((double)dValue);
        this.histogram.update(dValue);
        if (this.doubles.getCount() > 0L) {
            this.doubles.update(dValue);
        } else if (number instanceof Long || number instanceof Integer) {
            this.longs.update(number.longValue());
        } else {
            this.doubles.addLongs(this.longs);
            this.longs.reset();
            this.doubles.update(dValue);
        }
    }

    public NumberTracker merge(NumberTracker other) {
        KllFloatsSketch unionHistogram = KllFloatsSketch.heapify((Memory)Memory.wrap((byte[])this.histogram.toByteArray()));
        unionHistogram.merge(other.histogram);
        Union unionTheta = Union.builder().buildUnion();
        unionTheta.update((Sketch)this.thetaSketch);
        unionTheta.update((Sketch)other.thetaSketch);
        UpdateSketch thetaSketch = UpdateSketch.heapify((Memory)WritableMemory.wrap((byte[])unionTheta.toByteArray()));
        return NumberTracker.builder().setVariance(this.variance.merge(other.variance)).setDoubles(this.doubles.merge(other.doubles)).setLongs(this.longs.merge(other.longs)).setHistogram(unionHistogram).setThetaSketch(thetaSketch).build();
    }

    public NumbersMessage.Builder toProtobuf() {
        NumbersMessage.Builder builder = NumbersMessage.newBuilder().setVariance(this.variance.toProtobuf()).setTheta(ByteString.copyFrom((byte[])this.thetaSketch.toByteArray())).setHistogram(ByteString.copyFrom((byte[])this.histogram.toByteArray()));
        if (this.doubles.getCount() > 0L) {
            builder.setDoubles(this.doubles.toProtobuf());
        } else if (this.longs.getCount() > 0L) {
            builder.setLongs(this.longs.toProtobuf());
        }
        return builder;
    }

    public static NumberTracker fromProtobuf(NumbersMessage message) {
        WritableMemory tMem = WritableMemory.wrap((byte[])message.getTheta().toByteArray());
        Memory hMem = Memory.wrap((byte[])message.getHistogram().toByteArray());
        NumberTrackerBuilder builder = NumberTracker.builder().setThetaSketch(UpdateSketch.heapify((Memory)tMem)).setHistogram(KllFloatsSketch.heapify((Memory)hMem)).setVariance(VarianceTracker.fromProtobuf(message.getVariance()));
        Optional.ofNullable(message.getDoubles()).map(DoubleTracker::fromProtobuf).ifPresent(builder::setDoubles);
        Optional.ofNullable(message.getLongs()).map(LongTracker::fromProtobuf).ifPresent(builder::setLongs);
        return builder.build();
    }

    public static NumberTrackerBuilder builder() {
        return new NumberTrackerBuilder();
    }

    public VarianceTracker getVariance() {
        return this.variance;
    }

    public DoubleTracker getDoubles() {
        return this.doubles;
    }

    public LongTracker getLongs() {
        return this.longs;
    }

    public KllFloatsSketch getHistogram() {
        return this.histogram;
    }

    public UpdateSketch getThetaSketch() {
        return this.thetaSketch;
    }

    private NumberTracker(VarianceTracker variance, DoubleTracker doubles, LongTracker longs, KllFloatsSketch histogram, UpdateSketch thetaSketch) {
        this.variance = variance;
        this.doubles = doubles;
        this.longs = longs;
        this.histogram = histogram;
        this.thetaSketch = thetaSketch;
    }

    public static class NumberTrackerBuilder {
        private VarianceTracker variance;
        private DoubleTracker doubles;
        private LongTracker longs;
        private KllFloatsSketch histogram;
        private UpdateSketch thetaSketch;

        NumberTrackerBuilder() {
        }

        public NumberTrackerBuilder setVariance(VarianceTracker variance) {
            this.variance = variance;
            return this;
        }

        public NumberTrackerBuilder setDoubles(DoubleTracker doubles) {
            this.doubles = doubles;
            return this;
        }

        public NumberTrackerBuilder setLongs(LongTracker longs) {
            this.longs = longs;
            return this;
        }

        public NumberTrackerBuilder setHistogram(KllFloatsSketch histogram) {
            this.histogram = histogram;
            return this;
        }

        public NumberTrackerBuilder setThetaSketch(UpdateSketch thetaSketch) {
            this.thetaSketch = thetaSketch;
            return this;
        }

        public NumberTracker build() {
            return new NumberTracker(this.variance, this.doubles, this.longs, this.histogram, this.thetaSketch);
        }

        public String toString() {
            return "NumberTracker.NumberTrackerBuilder(variance=" + this.variance + ", doubles=" + this.doubles + ", longs=" + this.longs + ", histogram=" + this.histogram + ", thetaSketch=" + this.thetaSketch + ")";
        }
    }
}

