/*
 * Decompiled with CFR 0.152.
 */
package com.whylogs.core.statistics.datatypes;

import com.whylogs.core.message.VarianceMessage;

public class VarianceTracker {
    long count = 0L;
    double sum = 0.0;
    double mean = 0.0;

    public void update(double newValue) {
        ++this.count;
        double delta = newValue - this.mean;
        this.mean += delta / (double)this.count;
        double delta2 = newValue - this.mean;
        this.sum += delta * delta2;
    }

    public double stddev() {
        return Math.sqrt(this.variance());
    }

    public double variance() {
        if (this.count < 2L) {
            return Double.NaN;
        }
        return this.sum / ((double)this.count - 1.0);
    }

    public VarianceTracker merge(VarianceTracker other) {
        VarianceTracker thisCopy = this.copy();
        if (other.count == 0L) {
            return thisCopy;
        }
        if (this.count == 0L) {
            return other.copy();
        }
        double delta = thisCopy.mean - other.mean;
        long totalCount = thisCopy.count + other.count;
        thisCopy.sum += other.sum + Math.pow(delta, 2.0) * (double)thisCopy.count * (double)other.count / (double)totalCount;
        double thisRatio = (double)thisCopy.count / (double)totalCount;
        double otherRatio = 1.0 - thisRatio;
        thisCopy.mean = thisCopy.mean * thisRatio + other.mean * otherRatio;
        thisCopy.count += other.count;
        return thisCopy;
    }

    VarianceTracker copy() {
        VarianceTracker result = new VarianceTracker();
        result.count = this.count;
        result.sum = this.sum;
        result.mean = this.mean;
        return result;
    }

    public VarianceMessage.Builder toProtobuf() {
        return VarianceMessage.newBuilder().setCount(this.count).setMean(this.mean).setSum(this.sum);
    }

    public static VarianceTracker fromProtobuf(VarianceMessage message) {
        VarianceTracker tracker = new VarianceTracker();
        tracker.count = message.getCount();
        tracker.mean = message.getMean();
        tracker.sum = message.getSum();
        return tracker;
    }

    public long getCount() {
        return this.count;
    }

    public double getSum() {
        return this.sum;
    }

    public double getMean() {
        return this.mean;
    }
}

