/*
 * Decompiled with CFR 0.152.
 */
package com.whylogs.core.utils;

import com.google.protobuf.ByteString;
import com.whylogs.core.message.DatasetSummary;
import java.time.Instant;
import java.util.Set;
import java.util.stream.Collectors;

public final class ProtobufHelper {
    public static String summaryToString(DatasetSummary summary) {
        String name = summary.getProperties().getSessionId();
        String tags = summary.getProperties().getTagsList().asByteStringList().stream().map(ByteString::toStringUtf8).collect(Collectors.joining(","));
        String timestamp = Instant.ofEpochMilli(summary.getProperties().getSessionTimestamp()).toString();
        Set<String> columns = summary.getColumnsMap().keySet();
        return String.format("Name: %s. Tags: %s. Timestamp: %s. Columns: %s", name, tags, timestamp, columns);
    }

    private ProtobufHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

