/*
 * Decompiled with CFR 0.152.
 */
package com.whylogs.core;

import com.google.common.base.Preconditions;
import com.whylogs.core.SummaryConverters;
import com.whylogs.core.message.ColumnMessage;
import com.whylogs.core.message.ColumnSummary;
import com.whylogs.core.message.InferredType;
import com.whylogs.core.message.NumberSummary;
import com.whylogs.core.message.SchemaSummary;
import com.whylogs.core.message.StringsSummary;
import com.whylogs.core.statistics.CountersTracker;
import com.whylogs.core.statistics.NumberTracker;
import com.whylogs.core.statistics.SchemaTracker;
import com.whylogs.core.statistics.datatypes.StringTracker;
import com.whylogs.core.types.TypedData;
import com.whylogs.core.types.TypedDataConverter;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;

public class ColumnProfile {
    private static final Set<InferredType.Type> NUMERIC_TYPES = Stream.of(InferredType.Type.FRACTIONAL, InferredType.Type.INTEGRAL).collect(Collectors.toSet());
    @NonNull
    private final String columnName;
    @NonNull
    private final CountersTracker counters;
    @NonNull
    private final SchemaTracker schemaTracker;
    @NonNull
    private final NumberTracker numberTracker;
    @NonNull
    private final StringTracker stringTracker;

    public ColumnProfile(String columnName) {
        this.columnName = columnName;
        this.counters = new CountersTracker();
        this.schemaTracker = new SchemaTracker();
        this.numberTracker = new NumberTracker();
        this.stringTracker = new StringTracker();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void track(Object value) {
        ColumnProfile columnProfile = this;
        synchronized (columnProfile) {
            this.counters.incrementCount();
            if (value == null) {
                this.counters.incrementNull();
                return;
            }
            if (value instanceof String) {
                this.stringTracker.update((String)value);
            }
            TypedData typedData = TypedDataConverter.convert(value);
            this.schemaTracker.track(typedData.getType());
            switch (typedData.getType()) {
                case FRACTIONAL: {
                    this.numberTracker.track(typedData.getFractional());
                    break;
                }
                case INTEGRAL: {
                    this.numberTracker.track(typedData.getIntegralValue());
                    break;
                }
                case BOOLEAN: {
                    if (!typedData.isBooleanValue()) break;
                    this.counters.incrementTrue();
                }
            }
        }
    }

    public ColumnSummary toColumnSummary() {
        SchemaSummary.Builder schema = SummaryConverters.fromSchemaTracker(this.schemaTracker);
        ColumnSummary.Builder builder = ColumnSummary.newBuilder().setCounters(this.counters.toProtobuf());
        if (schema != null) {
            NumberSummary numberSummary;
            builder.setSchema(schema);
            if (schema.getInferredType().getType() == InferredType.Type.STRING) {
                StringsSummary stringSummary = SummaryConverters.fromStringTracker(this.stringTracker);
                if (stringSummary != null) {
                    builder.setStringSummary(stringSummary);
                }
            } else if (NUMERIC_TYPES.contains((Object)schema.getInferredType().getType()) && (numberSummary = SummaryConverters.fromNumberTracker(this.numberTracker)) != null) {
                builder.setNumberSummary(numberSummary);
            }
        }
        return builder.build();
    }

    public ColumnProfile merge(ColumnProfile other) {
        Preconditions.checkArgument((boolean)this.columnName.equals(other.columnName), (String)"Mismatched column name. Expected [%s], got [%s]", (Object)this.columnName, (Object)other.columnName);
        return ColumnProfile.builder().setColumnName(this.columnName).setCounters(this.counters.merge(other.counters)).setNumberTracker(this.numberTracker.merge(other.numberTracker)).setSchemaTracker(this.schemaTracker.merge(other.schemaTracker)).setStringTracker(this.stringTracker.merge(other.stringTracker)).build();
    }

    public ColumnMessage.Builder toProtobuf() {
        return ColumnMessage.newBuilder().setName(this.columnName).setCounters(this.counters.toProtobuf()).setSchema(this.schemaTracker.toProtobuf()).setNumbers(this.numberTracker.toProtobuf()).setStrings(this.stringTracker.toProtobuf());
    }

    public static ColumnProfile fromProtobuf(ColumnMessage message) {
        return ColumnProfile.builder().setColumnName(message.getName()).setCounters(CountersTracker.fromProtobuf(message.getCounters())).setSchemaTracker(SchemaTracker.fromProtobuf(message.getSchema())).setNumberTracker(NumberTracker.fromProtobuf(message.getNumbers())).setStringTracker(StringTracker.fromProtobuf(message.getStrings())).build();
    }

    public static ColumnProfileBuilder builder() {
        return new ColumnProfileBuilder();
    }

    private ColumnProfile(@NonNull String columnName, @NonNull CountersTracker counters, @NonNull SchemaTracker schemaTracker, @NonNull NumberTracker numberTracker, @NonNull StringTracker stringTracker) {
        if (columnName == null) {
            throw new NullPointerException("columnName is marked non-null but is null");
        }
        if (counters == null) {
            throw new NullPointerException("counters is marked non-null but is null");
        }
        if (schemaTracker == null) {
            throw new NullPointerException("schemaTracker is marked non-null but is null");
        }
        if (numberTracker == null) {
            throw new NullPointerException("numberTracker is marked non-null but is null");
        }
        if (stringTracker == null) {
            throw new NullPointerException("stringTracker is marked non-null but is null");
        }
        this.columnName = columnName;
        this.counters = counters;
        this.schemaTracker = schemaTracker;
        this.numberTracker = numberTracker;
        this.stringTracker = stringTracker;
    }

    @NonNull
    public String getColumnName() {
        return this.columnName;
    }

    @NonNull
    public CountersTracker getCounters() {
        return this.counters;
    }

    @NonNull
    public SchemaTracker getSchemaTracker() {
        return this.schemaTracker;
    }

    @NonNull
    public NumberTracker getNumberTracker() {
        return this.numberTracker;
    }

    @NonNull
    public StringTracker getStringTracker() {
        return this.stringTracker;
    }

    public static class ColumnProfileBuilder {
        private String columnName;
        private CountersTracker counters;
        private SchemaTracker schemaTracker;
        private NumberTracker numberTracker;
        private StringTracker stringTracker;

        ColumnProfileBuilder() {
        }

        public ColumnProfileBuilder setColumnName(@NonNull String columnName) {
            if (columnName == null) {
                throw new NullPointerException("columnName is marked non-null but is null");
            }
            this.columnName = columnName;
            return this;
        }

        public ColumnProfileBuilder setCounters(@NonNull CountersTracker counters) {
            if (counters == null) {
                throw new NullPointerException("counters is marked non-null but is null");
            }
            this.counters = counters;
            return this;
        }

        public ColumnProfileBuilder setSchemaTracker(@NonNull SchemaTracker schemaTracker) {
            if (schemaTracker == null) {
                throw new NullPointerException("schemaTracker is marked non-null but is null");
            }
            this.schemaTracker = schemaTracker;
            return this;
        }

        public ColumnProfileBuilder setNumberTracker(@NonNull NumberTracker numberTracker) {
            if (numberTracker == null) {
                throw new NullPointerException("numberTracker is marked non-null but is null");
            }
            this.numberTracker = numberTracker;
            return this;
        }

        public ColumnProfileBuilder setStringTracker(@NonNull StringTracker stringTracker) {
            if (stringTracker == null) {
                throw new NullPointerException("stringTracker is marked non-null but is null");
            }
            this.stringTracker = stringTracker;
            return this;
        }

        public ColumnProfile build() {
            return new ColumnProfile(this.columnName, this.counters, this.schemaTracker, this.numberTracker, this.stringTracker);
        }

        public String toString() {
            return "ColumnProfile.ColumnProfileBuilder(columnName=" + this.columnName + ", counters=" + this.counters + ", schemaTracker=" + this.schemaTracker + ", numberTracker=" + this.numberTracker + ", stringTracker=" + this.stringTracker + ")";
        }
    }
}

