/*
 * Decompiled with CFR 0.152.
 */
package com.whylogs.core.datetime;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class DateTimeFormatParser<TIME_FORMAT extends TemporalAccessor> {
    private final Class<TIME_FORMAT> timeFormat;
    private final BiFunction<DateTimeFormatter, String, Instant> function;
    static final DateTimeFormatParser<ZonedDateTime> ZONED_DATETIME = new DateTimeFormatParser<ZonedDateTime>(ZonedDateTime.class, (dateTimeFormatter, input) -> {
        ZonedDateTime dateTime = ZonedDateTime.parse(input, dateTimeFormatter);
        return dateTime.toInstant();
    });
    static final DateTimeFormatParser<LocalDateTime> LOCAL_DATETIME = new DateTimeFormatParser<LocalDateTime>(LocalDateTime.class, (dateTimeFormatter, input) -> {
        LocalDateTime dateTime = LocalDateTime.parse(input, dateTimeFormatter);
        return dateTime.atZone(ZoneOffset.UTC).toInstant();
    });
    static final DateTimeFormatParser<LocalTime> LOCAL_TIME = new DateTimeFormatParser<LocalTime>(LocalTime.class, (dateTimeFormatter, input) -> {
        LocalTime dateTime = LocalTime.parse(input, dateTimeFormatter);
        return dateTime.atDate(LocalDate.now()).atZone(ZoneOffset.UTC).toInstant();
    });
    static final DateTimeFormatParser<MonthDay> MONTH_DAY = new DateTimeFormatParser<MonthDay>(MonthDay.class, (dateTimeFormatter, input) -> {
        MonthDay dateTime = MonthDay.parse(input, dateTimeFormatter);
        int currentYear = Year.now().getValue();
        return dateTime.atYear(currentYear).atStartOfDay().atZone(ZoneOffset.UTC).toInstant();
    });
    static final DateTimeFormatParser<LocalDate> LOCAL_DATE = new DateTimeFormatParser<LocalDate>(LocalDate.class, (dateTimeFormatter, input) -> {
        LocalDate dateTime = LocalDate.parse(input, dateTimeFormatter);
        return dateTime.atStartOfDay().atZone(ZoneOffset.UTC).toInstant();
    });
    static final DateTimeFormatParser<YearMonth> YEAR_MONTH = new DateTimeFormatParser<YearMonth>(YearMonth.class, (dateTimeFormatter, input) -> {
        YearMonth dateTime = YearMonth.parse(input, dateTimeFormatter);
        return dateTime.atDay(1).atStartOfDay().atZone(ZoneOffset.UTC).toInstant();
    });
    static final DateTimeFormatParser<Year> YEAR = new DateTimeFormatParser<Year>(Year.class, (dateTimeFormatter, input) -> {
        Year dateTime = Year.parse(input, dateTimeFormatter);
        return dateTime.atMonth(1).atDay(1).atStartOfDay().atZone(ZoneOffset.UTC).toInstant();
    });
    static final DateTimeFormatParser<Instant> EPOCH_SECONDS = new DateTimeFormatParser<Instant>(Instant.class, (dateTimeFormatter, input) -> {
        try {
            return Instant.ofEpochSecond(Long.parseLong(input));
        }
        catch (NumberFormatException e) {
            throw new DateTimeParseException("Invalid number format", (CharSequence)input, 0, e);
        }
    });
    static final DateTimeFormatParser<Instant> EPOCH_MILLISECONDS = new DateTimeFormatParser<Instant>(Instant.class, (dateTimeFormatter, input) -> {
        try {
            return Instant.ofEpochMilli(Long.parseLong(input));
        }
        catch (NumberFormatException e) {
            throw new DateTimeParseException("Invalid number format", (CharSequence)input, 0, e);
        }
    });
    static final Set<Class<?>> SUPPORT_TIME_CLASSES = Stream.of(ZONED_DATETIME, LOCAL_DATE, LOCAL_TIME, MONTH_DAY, LOCAL_DATE, YEAR_MONTH, YEAR, EPOCH_SECONDS, EPOCH_MILLISECONDS).map(DateTimeFormatParser::getTimeFormatClass).collect(Collectors.toSet());

    public DateTimeFormatParser(Class<TIME_FORMAT> timeFormat, BiFunction<DateTimeFormatter, String, Instant> function) {
        this.timeFormat = timeFormat;
        this.function = function;
    }

    public Class<TIME_FORMAT> getTimeFormatClass() {
        return this.timeFormat;
    }

    public Instant parse(DateTimeFormatter formatter, String input) {
        return this.function.apply(formatter, input);
    }
}

