/*
 * Decompiled with CFR 0.152.
 */
package com.whylogs.core.statistics.datatypes;

import com.whylogs.core.message.LongsMessage;

public class LongTracker {
    private long min;
    private long max;
    private long sum;
    private long count;

    public LongTracker() {
        this.reset();
    }

    public Double getMean() {
        if (this.count == 0L) {
            return null;
        }
        return (double)this.sum / (double)this.count;
    }

    public void update(long value) {
        if (value > this.max) {
            this.max = value;
        }
        if (value < this.min) {
            this.min = value;
        }
        ++this.count;
        this.sum += value;
    }

    public LongTracker merge(LongTracker other) {
        LongTracker thisCopy = new LongTracker(this.min, this.max, this.sum, this.count);
        if (other.min < thisCopy.min) {
            thisCopy.min = other.min;
        }
        if (other.max > thisCopy.max) {
            thisCopy.max = other.max;
        }
        thisCopy.sum += other.sum;
        thisCopy.count += other.count;
        return thisCopy;
    }

    public void reset() {
        this.min = Long.MAX_VALUE;
        this.max = Long.MIN_VALUE;
        this.sum = 0L;
        this.count = 0L;
    }

    public LongsMessage.Builder toProtobuf() {
        return LongsMessage.newBuilder().setCount(this.count).setSum(this.sum).setMin(this.min).setMax(this.max);
    }

    public static LongTracker fromProtobuf(LongsMessage message) {
        LongTracker tracker = new LongTracker();
        tracker.count = message.getCount();
        tracker.max = message.getMax();
        tracker.min = message.getMin();
        tracker.sum = message.getSum();
        return tracker;
    }

    public long getMin() {
        return this.min;
    }

    public long getMax() {
        return this.max;
    }

    public long getSum() {
        return this.sum;
    }

    public long getCount() {
        return this.count;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LongTracker)) {
            return false;
        }
        LongTracker other = (LongTracker)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMin() != other.getMin()) {
            return false;
        }
        if (this.getMax() != other.getMax()) {
            return false;
        }
        if (this.getSum() != other.getSum()) {
            return false;
        }
        return this.getCount() == other.getCount();
    }

    protected boolean canEqual(Object other) {
        return other instanceof LongTracker;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $min = this.getMin();
        result = result * 59 + (int)($min >>> 32 ^ $min);
        long $max = this.getMax();
        result = result * 59 + (int)($max >>> 32 ^ $max);
        long $sum = this.getSum();
        result = result * 59 + (int)($sum >>> 32 ^ $sum);
        long $count = this.getCount();
        result = result * 59 + (int)($count >>> 32 ^ $count);
        return result;
    }

    private LongTracker(long min, long max, long sum, long count) {
        this.min = min;
        this.max = max;
        this.sum = sum;
        this.count = count;
    }
}

