package com.whylogs;

import com.google.common.collect.ImmutableMap;
import com.whylogs.core.ColumnProfile;
import com.whylogs.core.DatasetProfile;
import java.time.Instant;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import lombok.val;

public class Logger implements AutoCloseable {
  private final DatasetProfile profile;

  private boolean isClosed;

  public Logger(
      String name,
      String sessionId,
      Instant sessionTimestamp,
      Instant datasetTimestamp,
      Map<String, String> tags,
      Map<String, ColumnProfile> metadata) {
    val fullTags = ImmutableMap.<String, String>builder().putAll(tags).put("Name", name).build();
    this.profile =
        new DatasetProfile(
            sessionId, sessionTimestamp, datasetTimestamp, fullTags, ImmutableMap.copyOf(metadata));
  }

  public Logger(String name, Instant datasetTimestamp) {
    this(
        name,
        UUID.randomUUID().toString(),
        Instant.now(),
        datasetTimestamp,
        Collections.emptyMap(),
        Collections.emptyMap());
  }

  public void log(String feature, Object value) {
    this.profile.track(feature, value);
  }

  public void log(Map<String, ?> features) {
    this.profile.track(features);
  }

  @Override
  public void close() throws Exception {
    if (this.isClosed) {
      // todo: print out warning
      return;
    }

    profile.toProtobuf();
    // TODO: write to disk
  }
}
