/*
 * Decompiled with CFR 0.152.
 */
package com.whylogs.core.iterator;

import com.whylogs.core.message.ColumnMessage;
import com.whylogs.core.message.ColumnsChunkSegment;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ColumnsChunkSegmentIterator
implements Iterator<ColumnsChunkSegment> {
    private static final int MAX_LEN_IN_BYTES = 999990;
    private final int maxChunkLength;
    private final Iterator<ColumnMessage> iterator;
    private final ColumnsChunkSegment.Builder builder;
    private int contentLength;
    private int numberOfColumns;

    public ColumnsChunkSegmentIterator(Iterator<ColumnMessage> iterator, String marker) {
        this(999990, iterator, marker);
    }

    ColumnsChunkSegmentIterator(int maxChunkLength, Iterator<ColumnMessage> iterator, String marker) {
        this.maxChunkLength = maxChunkLength;
        this.iterator = iterator;
        this.builder = ColumnsChunkSegment.newBuilder().setMarker(marker);
        this.contentLength = 0;
        this.numberOfColumns = 0;
    }

    @Override
    public boolean hasNext() {
        if (this.numberOfColumns > 0) {
            return true;
        }
        return this.iterator.hasNext();
    }

    @Override
    public ColumnsChunkSegment next() {
        while (this.iterator.hasNext()) {
            boolean canItemBeAppended;
            ColumnMessage columnMessage = this.iterator.next();
            int messageLen = columnMessage.getSerializedSize();
            int candidateContentSize = this.contentLength + messageLen;
            boolean bl = canItemBeAppended = candidateContentSize <= this.maxChunkLength;
            if (canItemBeAppended) {
                this.builder.addColumns(columnMessage);
                ++this.numberOfColumns;
                this.contentLength = candidateContentSize;
                continue;
            }
            ColumnsChunkSegment result = this.builder.build();
            this.builder.clearColumns();
            this.builder.addColumns(columnMessage);
            this.numberOfColumns = 1;
            this.contentLength = messageLen;
            return result;
        }
        if (this.numberOfColumns > 0) {
            ColumnsChunkSegment result = this.builder.build();
            this.builder.clearColumns();
            this.contentLength = 0;
            this.numberOfColumns = 0;
            return result;
        }
        throw new NoSuchElementException();
    }
}

