/*
 * Decompiled with CFR 0.152.
 */
package com.whylogs.core.types;

import com.whylogs.core.message.InferredType;
import com.whylogs.core.types.TypedData;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class TypedDataConverter {
    private static final Pattern FRACTIONAL = Pattern.compile("^[-+]? ?\\d+[.]\\d+$");
    private static final Pattern INTEGRAL = Pattern.compile("^[-+]? ?\\d+$");
    private static final Pattern BOOLEAN = Pattern.compile("^(?i)true|false$");
    private static final Pattern EMPTY_SPACES = Pattern.compile("\\s");
    private static final ThreadLocal<Matcher> FRACTIONAL_MATCHER = ThreadLocal.withInitial(() -> FRACTIONAL.matcher(""));
    private static final ThreadLocal<Matcher> INTEGRAL_MATCHER = ThreadLocal.withInitial(() -> INTEGRAL.matcher(""));
    private static final ThreadLocal<Matcher> BOOLEAN_MATCHER = ThreadLocal.withInitial(() -> BOOLEAN.matcher(""));
    private static final ThreadLocal<Matcher> EMPTY_SPACES_REMOVER = ThreadLocal.withInitial(() -> EMPTY_SPACES.matcher(""));
    private static final Set<InferredType.Type> NUMERIC_TYPES = Stream.of(InferredType.Type.FRACTIONAL, InferredType.Type.INTEGRAL).collect(Collectors.toSet());

    public static TypedData convert(Object data) {
        if (data == null) {
            return null;
        }
        if (data instanceof String) {
            String strData = (String)data;
            INTEGRAL_MATCHER.get().reset(strData);
            if (INTEGRAL_MATCHER.get().matches()) {
                String trimmedText = EMPTY_SPACES_REMOVER.get().reset(strData).replaceAll("");
                return TypedData.integralValue(Long.parseLong(trimmedText));
            }
            FRACTIONAL_MATCHER.get().reset(strData);
            if (FRACTIONAL_MATCHER.get().matches()) {
                String trimmedText = EMPTY_SPACES_REMOVER.get().reset(strData).replaceAll("");
                return TypedData.fractionalValue(Double.parseDouble(trimmedText));
            }
            BOOLEAN_MATCHER.get().reset(strData);
            if (BOOLEAN_MATCHER.get().matches()) {
                String trimmedText = EMPTY_SPACES_REMOVER.get().reset(strData).replaceAll("");
                return TypedData.booleanValue(Boolean.parseBoolean(trimmedText));
            }
            return TypedData.stringValue(strData);
        }
        if (data instanceof Double || data instanceof Float) {
            double doubleValue = ((Number)data).doubleValue();
            return TypedData.fractionalValue(doubleValue);
        }
        if (data instanceof Integer || data instanceof Long || data instanceof Short) {
            long longValue = ((Number)data).longValue();
            return TypedData.integralValue(longValue);
        }
        if (data instanceof Boolean) {
            return TypedData.booleanValue((Boolean)data);
        }
        return TypedData.unknownValue();
    }

    private TypedDataConverter() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

