/*
 * Decompiled with CFR 0.152.
 */
package com.whylogs.core;

import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;
import com.whylogs.core.SummaryConverters;
import com.whylogs.core.message.ColumnMessage;
import com.whylogs.core.message.ColumnSummary;
import com.whylogs.core.message.HllSketchMessage;
import com.whylogs.core.message.NumberSummary;
import com.whylogs.core.message.SchemaSummary;
import com.whylogs.core.statistics.CountersTracker;
import com.whylogs.core.statistics.NumberTracker;
import com.whylogs.core.statistics.SchemaTracker;
import com.whylogs.core.statistics.datatypes.StringTracker;
import com.whylogs.core.types.TypedData;
import com.whylogs.core.types.TypedDataConverter;
import com.whylogs.core.utils.sketches.FrequentStringsSketch;
import lombok.NonNull;
import org.apache.datasketches.ArrayOfItemsSerDe;
import org.apache.datasketches.frequencies.ItemsSketch;
import org.apache.datasketches.hll.HllSketch;
import org.apache.datasketches.hll.Union;
import org.apache.datasketches.memory.Memory;

public class ColumnProfile {
    public static final int FREQUENT_MAX_LG_K = 7;
    private static final int CARDINALITY_LG_K = 12;
    @NonNull
    private final String columnName;
    @NonNull
    private final CountersTracker counters;
    @NonNull
    private final SchemaTracker schemaTracker;
    @NonNull
    private final NumberTracker numberTracker;
    @NonNull
    private final ItemsSketch<String> frequentItems;
    @NonNull
    private final HllSketch cardinalityTracker;

    public ColumnProfile(String columnName) {
        this.columnName = columnName;
        this.counters = new CountersTracker();
        this.schemaTracker = new SchemaTracker();
        this.numberTracker = new NumberTracker();
        this.frequentItems = FrequentStringsSketch.create();
        this.cardinalityTracker = new HllSketch(12);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void track(Object value) {
        ColumnProfile columnProfile = this;
        synchronized (columnProfile) {
            this.counters.incrementCount();
            if (value == null) {
                this.counters.incrementNull();
                return;
            }
            if (value instanceof String) {
                String stringValue = (String)value;
                this.frequentItems.update((Object)stringValue);
            }
            TypedData typedData = TypedDataConverter.convert(value);
            this.schemaTracker.track(typedData.getType());
            switch (typedData.getType()) {
                case FRACTIONAL: {
                    this.frequentItems.update((Object)typedData.toString());
                    this.numberTracker.track(typedData.getFractional());
                    break;
                }
                case INTEGRAL: {
                    this.frequentItems.update((Object)typedData.toString());
                    this.numberTracker.track(typedData.getIntegralValue());
                    break;
                }
                case BOOLEAN: {
                    this.frequentItems.update((Object)typedData.toString());
                    if (!typedData.isBooleanValue()) break;
                    this.counters.incrementTrue();
                }
            }
        }
    }

    public ColumnSummary toColumnSummary() {
        SchemaSummary.Builder schema = SummaryConverters.fromSchemaTracker(this.schemaTracker);
        ColumnSummary.Builder builder = ColumnSummary.newBuilder().setCounters(this.counters.toProtobuf());
        if (schema != null) {
            NumberSummary numberSummary;
            builder.setSchema(schema);
            if (TypedDataConverter.NUMERIC_TYPES.contains((Object)schema.getInferredType().getType()) && (numberSummary = SummaryConverters.fromNumberTracker(this.numberTracker)) != null) {
                builder.setNumberSummary(numberSummary);
            }
        }
        return builder.build();
    }

    public ColumnProfile merge(ColumnProfile other) {
        Preconditions.checkArgument((boolean)this.columnName.equals(other.columnName), (String)"Mismatched column name. Expected [%s], got [%s]", (Object)this.columnName, (Object)other.columnName);
        Union mergedSketch = Union.heapify((byte[])this.cardinalityTracker.toCompactByteArray());
        mergedSketch.update(other.cardinalityTracker);
        Memory iMem = Memory.wrap((byte[])this.frequentItems.toByteArray((ArrayOfItemsSerDe)StringTracker.ARRAY_OF_STRINGS_SER_DE));
        ItemsSketch copyFreqItems = ItemsSketch.getInstance((Memory)iMem, (ArrayOfItemsSerDe)StringTracker.ARRAY_OF_STRINGS_SER_DE);
        copyFreqItems.merge(other.frequentItems);
        return ColumnProfile.builder().setColumnName(this.columnName).setCounters(this.counters.merge(other.counters)).setNumberTracker(this.numberTracker.merge(other.numberTracker)).setSchemaTracker(this.schemaTracker.merge(other.schemaTracker)).setCardinalityTracker(HllSketch.heapify((byte[])mergedSketch.toCompactByteArray())).setFrequentItems((ItemsSketch<String>)copyFreqItems).build();
    }

    public ColumnMessage.Builder toProtobuf() {
        HllSketchMessage.Builder hllSketchMessage = HllSketchMessage.newBuilder().setLgK(this.cardinalityTracker.getLgConfigK()).setSketch(ByteString.copyFrom((byte[])this.cardinalityTracker.toCompactByteArray()));
        return ColumnMessage.newBuilder().setName(this.columnName).setCounters(this.counters.toProtobuf()).setSchema(this.schemaTracker.toProtobuf()).setNumbers(this.numberTracker.toProtobuf()).setCardinalityTracker(hllSketchMessage).setFrequentItems(FrequentStringsSketch.toStringSketch(this.frequentItems));
    }

    public static ColumnProfile fromProtobuf(ColumnMessage message) {
        return ColumnProfile.builder().setColumnName(message.getName()).setCounters(CountersTracker.fromProtobuf(message.getCounters())).setSchemaTracker(SchemaTracker.fromProtobuf(message.getSchema())).setNumberTracker(NumberTracker.fromProtobuf(message.getNumbers())).setCardinalityTracker(HllSketch.heapify((byte[])message.getCardinalityTracker().getSketch().toByteArray())).setFrequentItems(FrequentStringsSketch.deserialize(message.getFrequentItems().getSketch())).build();
    }

    public static ColumnProfileBuilder builder() {
        return new ColumnProfileBuilder();
    }

    private ColumnProfile(@NonNull String columnName, @NonNull CountersTracker counters, @NonNull SchemaTracker schemaTracker, @NonNull NumberTracker numberTracker, @NonNull ItemsSketch<String> frequentItems, @NonNull HllSketch cardinalityTracker) {
        if (columnName == null) {
            throw new NullPointerException("columnName is marked non-null but is null");
        }
        if (counters == null) {
            throw new NullPointerException("counters is marked non-null but is null");
        }
        if (schemaTracker == null) {
            throw new NullPointerException("schemaTracker is marked non-null but is null");
        }
        if (numberTracker == null) {
            throw new NullPointerException("numberTracker is marked non-null but is null");
        }
        if (frequentItems == null) {
            throw new NullPointerException("frequentItems is marked non-null but is null");
        }
        if (cardinalityTracker == null) {
            throw new NullPointerException("cardinalityTracker is marked non-null but is null");
        }
        this.columnName = columnName;
        this.counters = counters;
        this.schemaTracker = schemaTracker;
        this.numberTracker = numberTracker;
        this.frequentItems = frequentItems;
        this.cardinalityTracker = cardinalityTracker;
    }

    @NonNull
    public String getColumnName() {
        return this.columnName;
    }

    @NonNull
    public CountersTracker getCounters() {
        return this.counters;
    }

    @NonNull
    public SchemaTracker getSchemaTracker() {
        return this.schemaTracker;
    }

    @NonNull
    public NumberTracker getNumberTracker() {
        return this.numberTracker;
    }

    @NonNull
    public ItemsSketch<String> getFrequentItems() {
        return this.frequentItems;
    }

    @NonNull
    public HllSketch getCardinalityTracker() {
        return this.cardinalityTracker;
    }

    public static class ColumnProfileBuilder {
        private String columnName;
        private CountersTracker counters;
        private SchemaTracker schemaTracker;
        private NumberTracker numberTracker;
        private ItemsSketch<String> frequentItems;
        private HllSketch cardinalityTracker;

        ColumnProfileBuilder() {
        }

        public ColumnProfileBuilder setColumnName(@NonNull String columnName) {
            if (columnName == null) {
                throw new NullPointerException("columnName is marked non-null but is null");
            }
            this.columnName = columnName;
            return this;
        }

        public ColumnProfileBuilder setCounters(@NonNull CountersTracker counters) {
            if (counters == null) {
                throw new NullPointerException("counters is marked non-null but is null");
            }
            this.counters = counters;
            return this;
        }

        public ColumnProfileBuilder setSchemaTracker(@NonNull SchemaTracker schemaTracker) {
            if (schemaTracker == null) {
                throw new NullPointerException("schemaTracker is marked non-null but is null");
            }
            this.schemaTracker = schemaTracker;
            return this;
        }

        public ColumnProfileBuilder setNumberTracker(@NonNull NumberTracker numberTracker) {
            if (numberTracker == null) {
                throw new NullPointerException("numberTracker is marked non-null but is null");
            }
            this.numberTracker = numberTracker;
            return this;
        }

        public ColumnProfileBuilder setFrequentItems(@NonNull ItemsSketch<String> frequentItems) {
            if (frequentItems == null) {
                throw new NullPointerException("frequentItems is marked non-null but is null");
            }
            this.frequentItems = frequentItems;
            return this;
        }

        public ColumnProfileBuilder setCardinalityTracker(@NonNull HllSketch cardinalityTracker) {
            if (cardinalityTracker == null) {
                throw new NullPointerException("cardinalityTracker is marked non-null but is null");
            }
            this.cardinalityTracker = cardinalityTracker;
            return this;
        }

        public ColumnProfile build() {
            return new ColumnProfile(this.columnName, this.counters, this.schemaTracker, this.numberTracker, this.frequentItems, this.cardinalityTracker);
        }

        public String toString() {
            return "ColumnProfile.ColumnProfileBuilder(columnName=" + this.columnName + ", counters=" + this.counters + ", schemaTracker=" + this.schemaTracker + ", numberTracker=" + this.numberTracker + ", frequentItems=" + this.frequentItems + ", cardinalityTracker=" + this.cardinalityTracker + ")";
        }
    }
}

