/*
 * Decompiled with CFR 0.152.
 */
package com.whylogs.core;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import com.whylogs.core.ColumnProfile;
import com.whylogs.core.SchemaInformation;
import com.whylogs.core.iterator.ColumnsChunkSegmentIterator;
import com.whylogs.core.message.ColumnMessage;
import com.whylogs.core.message.ColumnSummary;
import com.whylogs.core.message.ColumnsChunkSegment;
import com.whylogs.core.message.DatasetMetadataSegment;
import com.whylogs.core.message.DatasetProfileMessage;
import com.whylogs.core.message.DatasetProperties;
import com.whylogs.core.message.DatasetSummary;
import com.whylogs.core.message.MessageSegment;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.time.Instant;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import lombok.NonNull;

public class DatasetProfile
implements Serializable {
    private static final long serialVersionUID = -9221998596693275458L;
    String sessionId;
    Instant sessionTimestamp;
    Instant dataTimestamp;
    Map<String, String> tags;
    Map<String, String> metadata;
    Map<String, ColumnProfile> columns;

    public DatasetProfile(@NonNull String sessionId, @NonNull Instant sessionTimestamp, @Nullable Instant dataTimestamp, @NonNull Map<String, String> tags, @NonNull Map<String, ColumnProfile> columns) {
        if (sessionId == null) {
            throw new NullPointerException("sessionId is marked non-null but is null");
        }
        if (sessionTimestamp == null) {
            throw new NullPointerException("sessionTimestamp is marked non-null but is null");
        }
        if (tags == null) {
            throw new NullPointerException("tags is marked non-null but is null");
        }
        if (columns == null) {
            throw new NullPointerException("columns is marked non-null but is null");
        }
        this.sessionId = sessionId;
        this.sessionTimestamp = sessionTimestamp;
        this.dataTimestamp = dataTimestamp;
        this.columns = new ConcurrentHashMap<String, ColumnProfile>();
        this.tags = new ConcurrentHashMap<String, String>(Optional.ofNullable(tags).orElse(Collections.emptyMap()));
        this.metadata = new ConcurrentHashMap<String, String>();
        this.columns = new ConcurrentHashMap<String, ColumnProfile>(Optional.ofNullable(columns).orElse(Collections.emptyMap()));
    }

    public DatasetProfile(@NonNull String sessionId, @NonNull Instant sessionTimestamp, @NonNull Map<String, String> tags) {
        this(sessionId, sessionTimestamp, null, tags, Collections.emptyMap());
        if (sessionId == null) {
            throw new NullPointerException("sessionId is marked non-null but is null");
        }
        if (sessionTimestamp == null) {
            throw new NullPointerException("sessionTimestamp is marked non-null but is null");
        }
        if (tags == null) {
            throw new NullPointerException("tags is marked non-null but is null");
        }
    }

    public DatasetProfile(String sessionId, Instant sessionTimestamp) {
        this(sessionId, sessionTimestamp, Collections.emptyMap());
    }

    public Map<String, ColumnProfile> getColumns() {
        return Collections.unmodifiableMap(this.columns);
    }

    public DatasetProfile withMetadata(String key, String value) {
        this.metadata.put(key, value);
        return this;
    }

    public DatasetProfile withAllMetadata(Map<String, String> metadata) {
        this.metadata.putAll(metadata);
        return this;
    }

    private void validate() {
        Preconditions.checkNotNull((Object)this.sessionId);
        Preconditions.checkNotNull((Object)this.sessionTimestamp);
        Preconditions.checkNotNull(this.columns);
        Preconditions.checkNotNull(this.metadata);
        Preconditions.checkNotNull(this.tags);
    }

    public void track(String columnName, Object data) {
        this.trackSingleColumn(columnName, data);
    }

    private void trackSingleColumn(String columnName, Object data) {
        ColumnProfile columnProfile = this.columns.computeIfAbsent(columnName, ColumnProfile::new);
        columnProfile.track(data);
    }

    public void track(Map<String, ?> columns) {
        columns.forEach(this::track);
    }

    public DatasetSummary toSummary() {
        this.validate();
        Map<String, ColumnSummary> summaryColumns = this.columns.values().stream().map(Pair::fromColumn).collect(Collectors.toMap(Pair::getName, Pair::getStatistics));
        DatasetSummary.Builder summary = DatasetSummary.newBuilder().setProperties(this.toDatasetProperties()).putAllColumns(summaryColumns);
        return summary.build();
    }

    public Iterator<MessageSegment> toChunkIterator() {
        this.validate();
        String marker = this.sessionId + UUID.randomUUID().toString();
        DatasetProperties.Builder properties = this.toDatasetProperties();
        DatasetMetadataSegment.Builder metadataBuilder = DatasetMetadataSegment.newBuilder().setProperties(properties).setMarker(marker);
        MessageSegment metadataSegment = MessageSegment.newBuilder().setMarker(marker).setMetadata(metadataBuilder).build();
        Iterator<ColumnMessage> chunkedColumns = this.columns.values().stream().map(ColumnProfile::toProtobuf).map(ColumnMessage.Builder::build).iterator();
        Iterator columnSegmentMessages = Iterators.transform((Iterator)new ColumnsChunkSegmentIterator(chunkedColumns, marker), msg -> MessageSegment.newBuilder().setColumns((ColumnsChunkSegment)msg).build());
        return Iterators.concat((Iterator)Iterators.singletonIterator((Object)metadataSegment), (Iterator)columnSegmentMessages);
    }

    public DatasetProfile mergeStrict(@NonNull DatasetProfile other) {
        if (other == null) {
            throw new NullPointerException("other is marked non-null but is null");
        }
        Preconditions.checkArgument((boolean)Objects.equals(this.sessionId, other.sessionId), (String)"Mismatched name. Current name [%s] is merged with [%s]", (Object)this.sessionId, (Object)other.sessionId);
        Preconditions.checkArgument((boolean)Objects.equals(this.sessionTimestamp, other.sessionTimestamp), (String)"Mismatched session timestamp. Current ts [%s] is merged with [%s]", (Object)this.sessionTimestamp, (Object)other.sessionTimestamp);
        Preconditions.checkArgument((boolean)Objects.equals(this.dataTimestamp, other.dataTimestamp), (String)"Mismatched data timestamp. Current ts [%s] is merged with [%s]", (Object)this.dataTimestamp, (Object)other.dataTimestamp);
        Preconditions.checkArgument((boolean)Objects.equals(this.tags, other.tags), (String)"Mismatched tags. Current %s being merged with %s", this.tags, other.tags);
        return this.doMerge(other, this.tags);
    }

    public DatasetProfile merge(@NonNull DatasetProfile other) {
        if (other == null) {
            throw new NullPointerException("other is marked non-null but is null");
        }
        ImmutableMap.Builder sharedTags = ImmutableMap.builder();
        for (String tagKey : this.tags.keySet()) {
            String tagValue = this.tags.get(tagKey);
            if (!tagValue.equals(other.tags.get(tagKey))) continue;
            sharedTags.put((Object)tagKey, (Object)tagValue);
        }
        return this.doMerge(other, (Map<String, String>)sharedTags.build());
    }

    private DatasetProfile doMerge(@NonNull DatasetProfile other, Map<String, String> tags) {
        if (other == null) {
            throw new NullPointerException("other is marked non-null but is null");
        }
        this.validate();
        other.validate();
        DatasetProfile result = new DatasetProfile(this.sessionId, this.sessionTimestamp, this.dataTimestamp, tags, Collections.emptyMap());
        ImmutableMap.Builder sharedMetadata = ImmutableMap.builder();
        for (String mKey : this.metadata.keySet()) {
            String mValue = this.metadata.get(mKey);
            if (!mValue.equals(other.metadata.get(mKey))) continue;
            sharedMetadata.put((Object)mKey, (Object)mValue);
        }
        result.withAllMetadata((Map<String, String>)sharedMetadata.build());
        Sets.SetView unionColumns = Sets.union(this.columns.keySet(), other.columns.keySet());
        for (String column : unionColumns) {
            ColumnProfile emptyColumn = new ColumnProfile(column);
            ColumnProfile thisColumn = this.columns.getOrDefault(column, emptyColumn);
            ColumnProfile otherColumn = other.columns.getOrDefault(column, emptyColumn);
            result.columns.put(column, thisColumn.merge(otherColumn));
        }
        return result;
    }

    public DatasetProfileMessage.Builder toProtobuf() {
        this.validate();
        DatasetProperties.Builder properties = this.toDatasetProperties();
        DatasetProfileMessage.Builder builder = DatasetProfileMessage.newBuilder().setProperties(properties);
        this.columns.forEach((k, v) -> builder.putColumns((String)k, v.toProtobuf().build()));
        return builder;
    }

    public void writeTo(OutputStream out) throws IOException {
        this.toProtobuf().build().writeDelimitedTo(out);
    }

    public byte[] toBytes() throws IOException {
        DatasetProfileMessage msg = this.toProtobuf().build();
        ByteArrayOutputStream bos = new ByteArrayOutputStream(msg.getSerializedSize());
        msg.writeDelimitedTo(bos);
        return bos.toByteArray();
    }

    private DatasetProperties.Builder toDatasetProperties() {
        long dataTimeInMillis = this.dataTimestamp == null ? -1L : this.dataTimestamp.toEpochMilli();
        return DatasetProperties.newBuilder().setSessionId(this.sessionId).setSessionTimestamp(this.sessionTimestamp.toEpochMilli()).setDataTimestamp(dataTimeInMillis).putAllTags(this.tags).putAllMetadata(this.metadata).setSchemaMajorVersion(1).setSchemaMinorVersion(1);
    }

    public static DatasetProfile fromProtobuf(DatasetProfileMessage message) {
        DatasetProperties props = message.getProperties();
        SchemaInformation.validateSchema(props.getSchemaMajorVersion(), props.getSchemaMinorVersion());
        Map<String, String> tags = props.getTagsMap();
        Instant sessionTimestamp = Instant.ofEpochMilli(props.getSessionTimestamp());
        Instant dataTimestamp = props.getDataTimestamp() < 0L ? null : Instant.ofEpochMilli(props.getDataTimestamp());
        DatasetProfile ds = new DatasetProfile(props.getSessionId(), sessionTimestamp, dataTimestamp, tags, Collections.emptyMap());
        ds.withAllMetadata(props.getMetadataMap());
        message.getColumnsMap().forEach((k, v) -> ds.columns.put((String)k, ColumnProfile.fromProtobuf(v)));
        ds.validate();
        return ds;
    }

    public static DatasetProfile parse(InputStream in) throws IOException {
        DatasetProfileMessage msg = DatasetProfileMessage.parseDelimitedFrom(in);
        return DatasetProfile.fromProtobuf(msg);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.validate();
        this.writeTo(out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        DatasetProfile copy = DatasetProfile.parse(in);
        this.sessionId = copy.sessionId;
        this.sessionTimestamp = copy.sessionTimestamp;
        this.dataTimestamp = copy.dataTimestamp;
        this.metadata = copy.metadata;
        this.tags = copy.tags;
        this.columns = copy.columns;
        this.validate();
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public Instant getSessionTimestamp() {
        return this.sessionTimestamp;
    }

    public Instant getDataTimestamp() {
        return this.dataTimestamp;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    static final class Pair {
        private final String name;
        private final ColumnSummary statistics;

        static Pair fromColumn(ColumnProfile column) {
            return new Pair(column.getColumnName(), column.toColumnSummary());
        }

        public Pair(String name, ColumnSummary statistics) {
            this.name = name;
            this.statistics = statistics;
        }

        public String getName() {
            return this.name;
        }

        public ColumnSummary getStatistics() {
            return this.statistics;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Pair)) {
                return false;
            }
            Pair other = (Pair)o;
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            ColumnSummary this$statistics = this.getStatistics();
            ColumnSummary other$statistics = other.getStatistics();
            return !(this$statistics == null ? other$statistics != null : !((Object)this$statistics).equals(other$statistics));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            ColumnSummary $statistics = this.getStatistics();
            result = result * 59 + ($statistics == null ? 43 : ((Object)$statistics).hashCode());
            return result;
        }

        public String toString() {
            return "DatasetProfile.Pair(name=" + this.getName() + ", statistics=" + this.getStatistics() + ")";
        }
    }
}

