/*
 * Decompiled with CFR 0.152.
 */
package com.whylogs.core;

import com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SchemaInformation {
    private static final Logger log = LoggerFactory.getLogger(SchemaInformation.class);
    static final int SCHEMA_MAJOR_VERSION = 1;
    static final int SCHEMA_MINOR_VERSION = 2;

    static void validateSchema(int majorVersion, int minorVersion) {
        Preconditions.checkArgument((1 == majorVersion ? 1 : 0) != 0, (String)"Expect major version %s, got %s", (int)1, (int)majorVersion);
        Preconditions.checkArgument((2 >= minorVersion ? 1 : 0) != 0, (String)"Does not support forward compatibility. Minor version: %s, got: %s", (int)2, (int)minorVersion);
        if (2 > minorVersion) {
            log.warn("Expect minor version {}. Got: {}", (Object)2, (Object)minorVersion);
        }
    }

    private SchemaInformation() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

